/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.GroupedMulti;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.SpscLinkedArrayQueue;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MultiGroupByOp<T, K, V>
extends AbstractMultiOperator<T, GroupedMulti<K, V>> {
    private final Function<? super T, ? extends K> keySelector;
    private final Function<? super T, ? extends V> valueSelector;

    public MultiGroupByOp(Multi<T> upstream, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        super(upstream);
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
    }

    @Override
    public void subscribe(Subscriber<? super GroupedMulti<K, V>> downstream) {
        ConcurrentHashMap groups = new ConcurrentHashMap();
        MultiGroupByProcessor<? super T, ? extends K, ? extends V> processor = new MultiGroupByProcessor<T, K, V>(downstream, this.keySelector, this.valueSelector, groups);
        this.upstream.subscribe(processor);
    }

    private static final class State<T, K>
    implements Subscription,
    Publisher<T> {
        private final AtomicReference<Subscriber<? super T>> downstream = new AtomicReference();
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final AtomicLong requested = new AtomicLong();
        private final AtomicBoolean done = new AtomicBoolean();
        private final AtomicInteger wip = new AtomicInteger();
        private final K key;
        private final SpscLinkedArrayQueue<T> queue;
        private final MultiGroupByProcessor<?, K, T> parent;
        private Throwable failure;

        State(MultiGroupByProcessor<?, K, T> parent, K key) {
            this.parent = parent;
            this.queue = new SpscLinkedArrayQueue(128);
            this.key = key;
        }

        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            }
        }

        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.parent.cancel(this.key);
            }
        }

        public void subscribe(Subscriber<? super T> s) {
            if (this.downstream.compareAndSet(null, s)) {
                s.onSubscribe((Subscription)this);
                this.drain();
            } else {
                Subscriptions.fail(s, new IllegalStateException("only 1 subscriber allowed"));
            }
        }

        public void onNext(T t) {
            if (!this.done.get()) {
                this.queue.offer(t);
                this.drain();
            }
        }

        public void onError(Throwable e) {
            if (this.done.compareAndSet(false, true)) {
                this.failure = e;
                this.drain();
            }
        }

        public void onComplete() {
            if (this.done.compareAndSet(false, true)) {
                this.drain();
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SpscLinkedArrayQueue<T> q = this.queue;
            Subscriber<? super T> actual = this.downstream.get();
            while (true) {
                if (actual != null) {
                    long e;
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        boolean empty;
                        boolean isDone = this.done.get();
                        T v = q.poll();
                        boolean bl = empty = v == null;
                        if (this.hasCompleted(isDone, empty)) {
                            return;
                        }
                        if (empty) break;
                        actual.onNext(v);
                    }
                    if (e == r && this.hasCompleted(this.done.get(), q.isEmpty())) {
                        return;
                    }
                    if (e != 0L) {
                        if (r != Long.MAX_VALUE) {
                            this.requested.addAndGet(-e);
                        }
                        ((Subscription)this.parent.upstream.get()).request(e);
                    }
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
                if (actual != null) continue;
                actual = this.downstream.get();
            }
        }

        boolean hasCompleted(boolean isDone, boolean isEmpty) {
            if (this.cancelled.get()) {
                this.queue.clear();
                return true;
            }
            if (isDone) {
                Throwable e = this.failure;
                if (e != null) {
                    this.queue.clear();
                    this.downstream.get().onError(e);
                    return true;
                }
                if (isEmpty) {
                    this.downstream.get().onComplete();
                    return true;
                }
            }
            return false;
        }
    }

    static final class GroupedUnicast<K, T>
    extends AbstractMulti<T>
    implements GroupedMulti<K, T> {
        private final State<T, K> downstream;
        private final K key;

        public static <T, K> GroupedUnicast<K, T> createWith(K key, MultiGroupByProcessor<?, K, T> parent) {
            State<T, K> state = new State<T, K>(parent, key);
            return new GroupedUnicast<K, T>(key, state);
        }

        protected GroupedUnicast(K key, State<T, K> downstream) {
            this.key = key;
            this.downstream = downstream;
        }

        @Override
        public void subscribe(Subscriber<? super T> s) {
            this.downstream.subscribe(s);
        }

        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        protected Publisher<T> publisher() {
            return this;
        }
    }

    public static final class MultiGroupByProcessor<T, K, V>
    extends MultiOperatorProcessor<T, GroupedMulti<K, V>> {
        private final Function<? super T, ? extends K> keySelector;
        private final Function<? super T, ? extends V> valueSelector;
        private final Map<Object, GroupedUnicast<K, V>> groups;
        private final SpscLinkedArrayQueue<GroupedMulti<K, V>> queue;
        private static final Object NO_KEY = new Object();
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final AtomicLong requested = new AtomicLong();
        private final AtomicInteger groupCount = new AtomicInteger(1);
        private final AtomicInteger wip = new AtomicInteger();
        Throwable failure;
        volatile boolean finished;
        boolean done;

        public MultiGroupByProcessor(Subscriber<? super GroupedMulti<K, V>> downstream, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Map<Object, GroupedUnicast<K, V>> groups) {
            super(downstream);
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.groups = groups;
            this.queue = new SpscLinkedArrayQueue(128);
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe((Subscription)this);
                subscription.request(128L);
            } else {
                subscription.cancel();
            }
        }

        public void onNext(T item) {
            V value;
            K key;
            if (this.isDone()) {
                return;
            }
            try {
                key = this.keySelector.apply(item);
            }
            catch (Throwable ex) {
                super.cancel();
                super.onError(ex);
                return;
            }
            boolean newGroup = false;
            Object mapKey = key != null ? key : NO_KEY;
            GroupedUnicast<K, Object> group = this.groups.get(mapKey);
            if (group == null) {
                if (this.isCancelled()) {
                    return;
                }
                group = GroupedUnicast.createWith(key, this);
                this.groups.put(mapKey, group);
                this.groupCount.getAndIncrement();
                newGroup = true;
            }
            try {
                value = this.valueSelector.apply(item);
                if (value == null) {
                    throw new NullPointerException("The selector returned `null`");
                }
            }
            catch (Throwable ex) {
                super.cancel();
                super.onError(ex);
                return;
            }
            group.onNext(value);
            if (newGroup) {
                this.queue.offer(group);
                this.drain();
            }
        }

        @Override
        public void onError(Throwable throwable) {
            Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                this.done = true;
                this.groups.values().forEach(group -> group.onError(throwable));
                this.groups.clear();
                this.failure = throwable;
                this.finished = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                this.done = true;
                this.groups.values().forEach(GroupedUnicast::onComplete);
                this.groups.clear();
                this.finished = true;
                this.drain();
            }
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true) && this.groupCount.decrementAndGet() == 0) {
                Subscriptions.cancel(this.upstream);
            }
        }

        public void cancel(K key) {
            Object mapKey = key != null ? key : NO_KEY;
            this.groups.remove(mapKey);
            if (this.groupCount.decrementAndGet() == 0) {
                Subscriptions.cancel(this.upstream);
                if (this.wip.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        private void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SpscLinkedArrayQueue<GroupedMulti<K, V>> q = this.queue;
            do {
                long emitted;
                long requests = this.requested.get();
                for (emitted = 0L; emitted != requests; ++emitted) {
                    boolean hasNoMoreGroup;
                    boolean isDone = this.finished;
                    GroupedMulti<K, V> t = q.poll();
                    boolean bl = hasNoMoreGroup = t == null;
                    if (this.isDoneOrCancelled(isDone, hasNoMoreGroup, q)) {
                        return;
                    }
                    if (hasNoMoreGroup) break;
                    this.downstream.onNext(t);
                }
                if (emitted == requests && this.isDoneOrCancelled(this.finished, q.isEmpty(), q)) {
                    return;
                }
                if (emitted == 0L) continue;
                if (requests != Long.MAX_VALUE) {
                    this.requested.addAndGet(-emitted);
                }
                super.request(emitted);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        boolean isDoneOrCancelled(boolean d, boolean empty, SpscLinkedArrayQueue<?> q) {
            if (this.isCancelled()) {
                q.clear();
                return true;
            }
            if (d) {
                Throwable ex = this.failure;
                if (ex != null) {
                    q.clear();
                    this.downstream.onError(ex);
                    return true;
                }
                if (empty) {
                    this.downstream.onComplete();
                    return true;
                }
            }
            return false;
        }
    }
}

