/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.MultiCombineLatestOp;
import io.smallrye.mutiny.operators.multi.MultiZipOp;
import java.util.List;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class MultiItemCombineIterable {
    private boolean collectFailures;
    private boolean latest;
    private Iterable<? extends Publisher<?>> iterable;

    public MultiItemCombineIterable(Iterable<? extends Publisher<?>> iterable) {
        this.iterable = iterable;
    }

    public MultiItemCombineIterable collectFailures() {
        this.collectFailures = true;
        return this;
    }

    public MultiItemCombineIterable latestItems() {
        this.latest = true;
        return this;
    }

    public <O> Multi<O> using(Function<List<?>, O> combinator) {
        ParameterValidation.nonNull(combinator, "combinator");
        return this.combine(combinator);
    }

    <O> Multi<O> combine(Function<List<?>, ? extends O> combinator) {
        if (this.latest) {
            if (this.collectFailures) {
                return new MultiCombineLatestOp(this.iterable, combinator, 128, true);
            }
            return new MultiCombineLatestOp(this.iterable, combinator, 128, false);
        }
        if (this.collectFailures) {
            return new MultiZipOp<O>(this.iterable, combinator, 128, true);
        }
        return new MultiZipOp<O>(this.iterable, combinator, 128, false);
    }
}

