/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MapOperator<I, O>
implements Publisher<O> {
    private final Publisher<I> upstream;
    private final Function<I, O> mapper;

    public MapOperator(Publisher<I> upstream, Function<I, O> mapper) {
        this.upstream = upstream;
        this.mapper = mapper;
    }

    public void subscribe(Subscriber<? super O> subscriber) {
        this.upstream.subscribe((Subscriber)new MapProcessor(subscriber));
    }

    private class MapProcessor
    implements Processor<I, O>,
    Subscription {
        private final Subscriber<? super O> downstream;
        private Subscription subscription;
        private volatile boolean cancelled = false;

        public MapProcessor(Subscriber<? super O> downstream) {
            this.downstream = downstream;
        }

        public void subscribe(Subscriber<? super O> subscriber) {
        }

        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            this.downstream.onSubscribe((Subscription)this);
        }

        public void onNext(I i) {
            Object res;
            if (this.cancelled) {
                return;
            }
            try {
                res = Objects.requireNonNull(MapOperator.this.mapper.apply(i));
            }
            catch (Exception e) {
                this.subscription.cancel();
                this.onError(e);
                return;
            }
            this.downstream.onNext(res);
        }

        public void onError(Throwable throwable) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.downstream.onError(throwable);
        }

        public void onComplete() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.downstream.onComplete();
        }

        public void request(long n) {
            if (this.cancelled) {
                return;
            }
            this.subscription.request(n);
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.subscription.cancel();
        }
    }
}

