/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PublisherToCompletionStageSubscriber<T>
implements Subscriber<T> {
    private final CompletableFuture<Optional<T>> future;
    private final AtomicBoolean completed = new AtomicBoolean();
    private Subscription subscription;

    public PublisherToCompletionStageSubscriber(CompletableFuture<Optional<T>> future) {
        this.future = future;
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onNext(T value) {
        if (this.completed.compareAndSet(false, true)) {
            this.subscription.cancel();
            this.future.complete(Optional.of(value));
        }
    }

    public void onError(Throwable throwable) {
        if (this.completed.compareAndSet(false, true)) {
            this.subscription.cancel();
            this.future.completeExceptionally(throwable);
        }
    }

    public void onComplete() {
        if (this.completed.compareAndSet(false, true)) {
            this.future.complete(Optional.empty());
        }
    }
}

