/*
 * Decompiled with CFR 0.152.
 */
package _03_composition_transformation;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class _22_Multi_Chunks_To_Sentence_Stream_Custom_Operator {
    static final ScheduledExecutorService pool = Executors.newSingleThreadScheduledExecutor();

    public static void main(String[] args) throws InterruptedException {
        System.out.println("\u26a1\ufe0f Chunks of text to sentence stream (with a custom operator)");
        List<String> chunks = List.of("Hel", "lo ", "world\n", "Foo", " B", "ar ", "Baz\n");
        Multi.createFrom().iterable(chunks).plug(TokenToSentence::new).onItem().transformToUniAndConcatenate(line -> _22_Multi_Chunks_To_Sentence_Stream_Custom_Operator.sendText(line)).subscribe().with(line -> System.out.println(">>> " + line), Throwable::printStackTrace, pool::shutdownNow);
    }

    static Uni<String> sendText(String text) {
        return Uni.createFrom().item((Object)text).onItem().delayIt().onExecutor(pool).by(Duration.ofMillis(300L)).onItem().invoke(txt -> System.out.println("[sendText] " + txt));
    }

    static class TokenToSentence
    extends AbstractMultiOperator<String, String> {
        public TokenToSentence(Multi<? extends String> upstream) {
            super(upstream);
        }

        public void subscribe(MultiSubscriber<? super String> downstream) {
            this.upstream.subscribe().withSubscriber((MultiSubscriber)new TokenToSentenceProcessor(downstream));
        }

        private static class TokenToSentenceProcessor
        extends MultiOperatorProcessor<String, String> {
            private final StringBuilder builder = new StringBuilder();

            public TokenToSentenceProcessor(MultiSubscriber<? super String> downstream) {
                super(downstream);
            }

            public void onItem(String chunk) {
                this.builder.append(chunk);
                String current = this.builder.toString();
                if (current.endsWith("\n")) {
                    this.builder.setLength(0);
                    super.onItem((Object)current.substring(0, current.length() - 1));
                } else {
                    this.upstream.request(1L);
                }
            }
        }
    }
}

