/*
 * Decompiled with CFR 0.152.
 */
package _01_basics;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;

public class _17_Multi_By_Repeating {
    public static void main(String[] args) throws InterruptedException {
        System.out.println("\u26a1\ufe0f Multi by repeating");
        Multi.createBy().repeating().supplier(Service::fetchValue).until(n -> n > 1000000L).subscribe().with(System.out::println);
        System.out.println("\n----\n");
        CountDownLatch latch = new CountDownLatch(1);
        Multi.createBy().repeating().uni(Service::asyncFetchValue).atMost(10L).subscribe().with(System.out::println, Throwable::printStackTrace, latch::countDown);
        latch.await();
        System.out.println("\n----\n");
        Multi.createBy().repeating().completionStage(Service::queryDb).whilst(n -> n < 1000000L).subscribe().with(System.out::println);
    }

    static class Service {
        Service() {
        }

        static long fetchValue() {
            return ThreadLocalRandom.current().nextLong(1001000L);
        }

        static Uni<Long> asyncFetchValue() {
            return Uni.createFrom().completionStage(Service::queryDb);
        }

        static CompletionStage<Long> queryDb() {
            return CompletableFuture.supplyAsync(Service::fetchValue);
        }
    }
}

