/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.test;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiAssertSubscriber<T>
implements Subscriber<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private AtomicReference<Subscription> subscription = new AtomicReference();
    private AtomicLong requested = new AtomicLong();
    private List<T> items = new CopyOnWriteArrayList<T>();
    private List<Throwable> failures = new CopyOnWriteArrayList<Throwable>();
    private int numberOfSubscription = 0;
    private int numberOfCompletionEvents = 0;
    private boolean upfrontCancellation;

    public MultiAssertSubscriber(long requested, boolean cancelled) {
        this.requested.set(requested);
        this.upfrontCancellation = cancelled;
    }

    public MultiAssertSubscriber(long requested) {
        this(requested, false);
    }

    public static <T> MultiAssertSubscriber<T> create() {
        return new MultiAssertSubscriber<T>(0L);
    }

    public static <T> MultiAssertSubscriber<T> create(long requested) {
        return new MultiAssertSubscriber<T>(requested);
    }

    public MultiAssertSubscriber<T> assertCompletedSuccessfully() {
        this.assertHasNotFailed();
        int num = this.numberOfCompletionEvents;
        if (num == 0) {
            throw new AssertionError((Object)"Not yet completed");
        }
        if (num > 1) {
            throw new AssertionError((Object)("Too many completions: " + num));
        }
        return this;
    }

    public MultiAssertSubscriber<T> assertHasFailedWith(Class<? extends Throwable> typeOfException, String message) {
        this.assertHasNotCompleted();
        int count = this.failures.size();
        if (count == 0) {
            throw new AssertionError((Object)"The multi didn't failed");
        }
        if (count > 1) {
            throw new AssertionError((Object)("The multi emitted several failure events errors: " + count));
        }
        Throwable throwable = this.failures.get(0);
        Assertions.assertThat((Throwable)throwable).isInstanceOf(typeOfException);
        if (message != null) {
            Assertions.assertThat((Throwable)throwable).hasMessageContaining(message);
        }
        return this;
    }

    public MultiAssertSubscriber<T> assertHasNotFailed() {
        Assertions.assertThat(this.failures).hasSize(0);
        return this;
    }

    public MultiAssertSubscriber<T> assertHasNotReceivedAnyItem() {
        Assertions.assertThat(this.items).isEmpty();
        return this;
    }

    public MultiAssertSubscriber<T> assertHasNotCompleted() {
        Assertions.assertThat((int)this.numberOfCompletionEvents).isEqualTo(0);
        return this;
    }

    public MultiAssertSubscriber<T> assertSubscribed() {
        Assertions.assertThat((int)this.numberOfSubscription).isEqualTo(1);
        return this;
    }

    public MultiAssertSubscriber<T> assertNotSubscribed() {
        Assertions.assertThat((int)this.numberOfSubscription).isEqualTo(0);
        return this;
    }

    public MultiAssertSubscriber<T> assertTerminated() {
        Assertions.assertThat((long)this.latch.getCount()).isEqualTo(0L);
        return this;
    }

    public MultiAssertSubscriber<T> assertNotTerminated() {
        ((AbstractLongAssert)Assertions.assertThat((long)this.latch.getCount()).as("Multi did not complete yet", new Object[0])).isGreaterThan(0L);
        return this;
    }

    @SafeVarargs
    public final MultiAssertSubscriber<T> assertReceived(T ... expected) {
        Assertions.assertThat(this.items).containsExactly((Object[])expected);
        return this;
    }

    public MultiAssertSubscriber<T> await() {
        if (this.latch.getCount() == 0L) {
            return this;
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public MultiAssertSubscriber<T> await(Duration duration) {
        if (this.latch.getCount() == 0L) {
            return this;
        }
        try {
            if (!this.latch.await(duration.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new AssertionError((Object)"Not terminated before timeout");
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public MultiAssertSubscriber<T> cancel() {
        ((ObjectAssert)Assertions.assertThat((Object)this.subscription.get()).as("No subscription", new Object[0])).isNotNull();
        this.subscription.get().cancel();
        return this;
    }

    public MultiAssertSubscriber<T> request(long req) {
        this.requested.addAndGet(req);
        if (this.subscription.get() != null) {
            this.subscription.get().request(req);
        }
        return this;
    }

    public void onSubscribe(Subscription s) {
        ++this.numberOfSubscription;
        this.subscription.set(s);
        if (this.upfrontCancellation) {
            s.cancel();
        }
        if (this.requested.get() > 0L) {
            s.request(this.requested.get());
        }
    }

    public synchronized void onNext(T t) {
        this.items.add(t);
    }

    public void onError(Throwable t) {
        this.failures.add(t);
        this.latch.countDown();
    }

    public void onComplete() {
        ++this.numberOfCompletionEvents;
        this.latch.countDown();
    }

    public List<T> items() {
        return this.items;
    }

    public List<Throwable> failures() {
        return this.failures;
    }

    public MultiAssertSubscriber<T> run(Runnable action) {
        try {
            action.run();
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }
}

