/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.jakarta.streams.stages;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.jakarta.streams.Engine;
import io.smallrye.mutiny.jakarta.streams.operators.PublisherStage;
import io.smallrye.mutiny.jakarta.streams.operators.PublisherStageFactory;
import io.smallrye.mutiny.jakarta.streams.utils.CancellablePublisher;
import java.util.Objects;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.reactivestreams.Publisher;

public class ConcatStageFactory
implements PublisherStageFactory<Stage.Concat> {
    @Override
    public <O> PublisherStage<O> create(Engine engine, Stage.Concat stage) {
        Objects.requireNonNull(engine);
        Objects.requireNonNull(stage);
        Graph g1 = stage.getFirst();
        Graph g2 = stage.getSecond();
        return new ConcatStage(engine, g1, g2);
    }

    private class ConcatStage<O>
    implements PublisherStage<O> {
        private final Engine engine;
        private final Graph first;
        private final Graph second;

        ConcatStage(Engine engine, Graph g1, Graph g2) {
            this.engine = Objects.requireNonNull(engine);
            this.first = Objects.requireNonNull(g1);
            this.second = Objects.requireNonNull(g2);
        }

        @Override
        public Multi<O> get() {
            CancellablePublisher cancellable = new CancellablePublisher(this.engine.buildPublisher(this.second));
            return Multi.createBy().concatenating().streams(new Publisher[]{this.engine.buildPublisher(this.first), cancellable}).onTermination().invoke(cancellable::cancelIfNotSubscribed);
        }
    }
}

