/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.jakarta.streams;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.jakarta.streams.operators.Operator;
import io.smallrye.mutiny.jakarta.streams.operators.ProcessingStage;
import io.smallrye.mutiny.jakarta.streams.operators.ProcessorOperator;
import io.smallrye.mutiny.jakarta.streams.operators.PublisherOperator;
import io.smallrye.mutiny.jakarta.streams.operators.PublisherStage;
import io.smallrye.mutiny.jakarta.streams.operators.TerminalOperator;
import io.smallrye.mutiny.jakarta.streams.operators.TerminalStage;
import io.smallrye.mutiny.jakarta.streams.spi.Transformer;
import io.smallrye.mutiny.jakarta.streams.stages.Stages;
import io.smallrye.mutiny.jakarta.streams.utils.ConnectableProcessor;
import io.smallrye.mutiny.jakarta.streams.utils.DefaultSubscriberWithCompletionStage;
import io.smallrye.mutiny.jakarta.streams.utils.WrappedProcessor;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.eclipse.microprofile.reactive.streams.operators.spi.SubscriberWithCompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.spi.UnsupportedStageException;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;

public class Engine
implements ReactiveStreamsEngine {
    public <T> Publisher<T> buildPublisher(Graph graph) {
        Multi publisher = null;
        for (Stage stage : graph.getStages()) {
            Operator<Stage> operator = Stages.lookup(stage);
            if (publisher == null) {
                if (operator instanceof PublisherOperator) {
                    publisher = this.createPublisher(stage, (PublisherOperator)operator);
                    continue;
                }
                throw new IllegalArgumentException("Expecting a publisher stage, got a " + stage);
            }
            if (operator instanceof ProcessorOperator) {
                publisher = this.applyProcessors(publisher, stage, (ProcessorOperator)operator);
                continue;
            }
            throw new IllegalArgumentException("Expecting a processor stage, got a " + stage);
        }
        return publisher;
    }

    public <T, R> SubscriberWithCompletionStage<T, R> buildSubscriber(Graph graph) {
        ConnectableProcessor processor = new ConnectableProcessor();
        Multi flowable = Multi.createFrom().publisher(processor);
        for (Stage stage : graph.getStages()) {
            Operator<Stage> operator = Stages.lookup(stage);
            if (operator instanceof ProcessorOperator) {
                flowable = this.applyProcessors(flowable, stage, (ProcessorOperator)operator);
                continue;
            }
            if (operator instanceof TerminalOperator) {
                CompletionStage<R> result = this.applySubscriber(Transformer.apply(flowable), stage, (TerminalOperator)operator);
                return new DefaultSubscriberWithCompletionStage(processor, result);
            }
            throw new UnsupportedStageException(stage);
        }
        throw new IllegalArgumentException("The graph does not have a valid final stage");
    }

    public <T, R> Processor<T, R> buildProcessor(Graph graph) {
        ConnectableProcessor processor = new ConnectableProcessor();
        Multi multi = Multi.createFrom().publisher(processor);
        for (Stage stage : graph.getStages()) {
            Operator<Stage> operator = Stages.lookup(stage);
            multi = this.applyProcessors(multi, stage, (ProcessorOperator)operator);
        }
        return new WrappedProcessor(processor, multi);
    }

    public <T> CompletionStage<T> buildCompletion(Graph graph) {
        Multi flowable = null;
        for (Stage stage : graph.getStages()) {
            Operator<Stage> operator = Stages.lookup(stage);
            if (operator instanceof PublisherOperator) {
                flowable = this.createPublisher(stage, (PublisherOperator)operator);
                continue;
            }
            if (operator instanceof ProcessorOperator) {
                flowable = this.applyProcessors(flowable, stage, (ProcessorOperator)operator);
                continue;
            }
            return this.applySubscriber(flowable, stage, (TerminalOperator)operator);
        }
        throw new IllegalArgumentException("Graph did not have terminal stage");
    }

    private <I, O> Multi<O> applyProcessors(Multi<I> multi, Stage stage, ProcessorOperator operator) {
        ProcessingStage ps = operator.create(this, stage);
        return Transformer.apply(ps.apply(multi));
    }

    private <T, R> CompletionStage<R> applySubscriber(Multi<T> multi, Stage stage, TerminalOperator operator) {
        TerminalStage ps = operator.create(this, stage);
        return ps.apply(Transformer.apply(multi));
    }

    private <O> Multi<O> createPublisher(Stage stage, PublisherOperator operator) {
        PublisherStage ps = operator.create(this, stage);
        return Transformer.apply(ps.get());
    }
}

