/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.math;

import java.util.Objects;

public class Statistic<T> {
    final long n;
    final double m1;
    final double m2;
    final double m3;
    final double m4;
    final T min;
    final T max;

    public Statistic(long n, double m1, double m2, double m3, double m4, T min, T max) {
        this.n = n;
        this.m1 = m1;
        this.m2 = m2;
        this.m3 = m3;
        this.m4 = m4;
        this.min = min;
        this.max = max;
    }

    public double getAverage() {
        return this.m1;
    }

    public double getVariance() {
        return this.m2 / ((double)this.n - 1.0);
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public double getSkewness() {
        return Math.sqrt(this.n) * this.m3 / Math.pow(this.m2, 1.5);
    }

    public double getKurtosis() {
        return (double)this.n * this.m4 / (this.m2 * this.m2) - 3.0;
    }

    public long getCount() {
        return this.n;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statistic statistic = (Statistic)o;
        return this.n == statistic.n && Double.compare(statistic.m1, this.m1) == 0 && Double.compare(statistic.m2, this.m2) == 0 && Double.compare(statistic.m3, this.m3) == 0 && Double.compare(statistic.m4, this.m4) == 0 && Objects.equals(this.min, statistic.min) && Objects.equals(this.max, statistic.max);
    }

    public int hashCode() {
        return Objects.hash(this.n, this.m1, this.m2, this.m3, this.m4, this.min, this.max);
    }

    public String toString() {
        return "Statistic{size=" + this.n + ", min=" + String.valueOf(this.min) + ", max=" + String.valueOf(this.max) + ", average=" + this.getAverage() + ", variance=" + this.getVariance() + ", stdDeviation=" + this.getStandardDeviation() + ", skewness=" + this.getSkewness() + ", kurtosis=" + this.getKurtosis() + "}";
    }
}

