/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.math;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.math.AverageOperator;
import io.smallrye.mutiny.math.CountOperator;
import io.smallrye.mutiny.math.IndexOperator;
import io.smallrye.mutiny.math.MaxOperator;
import io.smallrye.mutiny.math.MedianOperator;
import io.smallrye.mutiny.math.MinOperator;
import io.smallrye.mutiny.math.OccurrenceOperator;
import io.smallrye.mutiny.math.Statistic;
import io.smallrye.mutiny.math.StatisticsOperator;
import io.smallrye.mutiny.math.SumOperator;
import io.smallrye.mutiny.math.TopOperator;
import io.smallrye.mutiny.tuples.Tuple2;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Math {
    private Math() {
    }

    public static <T> Function<Multi<T>, Multi<Long>> count() {
        return new CountOperator();
    }

    public static <T extends Number> Function<Multi<T>, Multi<Double>> sum() {
        return new SumOperator();
    }

    public static <T> Function<Multi<T>, Multi<Tuple2<Long, T>>> index() {
        return new IndexOperator();
    }

    public static <T extends Number> Function<Multi<T>, Multi<Double>> average() {
        return new AverageOperator();
    }

    public static <T extends Number> Function<Multi<T>, Multi<Double>> median() {
        return new MedianOperator();
    }

    public static <T extends Number> Function<Multi<T>, Multi<Statistic<T>>> statistics() {
        return new StatisticsOperator();
    }

    public static <T extends Comparable<T>> Function<Multi<T>, Multi<T>> min() {
        return new MinOperator();
    }

    public static <T extends Comparable<T>> Function<Multi<T>, Multi<T>> max() {
        return new MaxOperator();
    }

    public static <T extends Comparable<T>> Function<Multi<T>, Multi<List<T>>> top(int count) {
        return new TopOperator(count);
    }

    public static <T> Function<Multi<T>, Multi<Map<T, Long>>> occurrence() {
        return new OccurrenceOperator();
    }
}

