/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.math;

import io.smallrye.mutiny.Multi;
import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.Function;

public class MedianOperator<T extends Number>
implements Function<Multi<T>, Multi<Double>> {
    private final Queue<T> minHeap = new PriorityBlockingQueue<T>(11);
    private final Queue<T> maxHeap = new PriorityBlockingQueue(11, Comparator.reverseOrder());

    @Override
    public Multi<Double> apply(Multi<T> multi) {
        return multi.onItem().transform(x -> {
            this.push(x);
            return this.getMedian();
        });
    }

    void push(T num) {
        if (this.minHeap.size() == this.maxHeap.size()) {
            this.maxHeap.offer(num);
            this.minHeap.offer((Number)this.maxHeap.poll());
        } else {
            this.minHeap.offer(num);
            this.maxHeap.offer((Number)this.minHeap.poll());
        }
    }

    double getMedian() {
        if (this.minHeap.size() > this.maxHeap.size()) {
            return ((Number)this.minHeap.peek()).doubleValue();
        }
        return (((Number)this.minHeap.peek()).doubleValue() + ((Number)this.maxHeap.peek()).doubleValue()) / 2.0;
    }
}

