/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public final class TypeVariableReference
extends Type {
    private final String name;
    private TypeVariable target;

    TypeVariableReference(String name) {
        this(name, null, null);
    }

    TypeVariableReference(String name, TypeVariable target, AnnotationInstance[] annotations) {
        super(DotName.OBJECT_NAME, annotations);
        this.name = name;
        this.target = target;
    }

    @Override
    public DotName name() {
        if (this.target == null) {
            throw new IllegalStateException("Type variable reference " + this.name + " was not patched correctly");
        }
        return this.target.name();
    }

    public String identifier() {
        return this.name;
    }

    public TypeVariable follow() {
        if (this.target == null) {
            throw new IllegalStateException("Type variable reference " + this.name + " was not patched correctly");
        }
        return this.target;
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.TYPE_VARIABLE_REFERENCE;
    }

    @Override
    public TypeVariableReference asTypeVariableReference() {
        return this;
    }

    @Override
    Type copyType(AnnotationInstance[] newAnnotations) {
        return new TypeVariableReference(this.name, this.target, newAnnotations);
    }

    void setTarget(TypeVariable target) {
        if (target == null) {
            throw new IllegalArgumentException("Type variable reference target must not be null");
        }
        this.target = target;
    }

    @Override
    String toString(boolean simple) {
        StringBuilder builder = new StringBuilder();
        this.appendAnnotations(builder);
        builder.append(this.name);
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this.target == null) {
            throw new IllegalStateException("Type variable reference " + this.name + " was not patched correctly");
        }
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeVariableReference that = (TypeVariableReference)o;
        return this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        if (this.target == null) {
            throw new IllegalStateException("Type variable reference " + this.name + " was not patched correctly");
        }
        int hash = super.hashCode();
        hash = 31 * hash + this.name.hashCode();
        return hash;
    }

    @Override
    boolean internEquals(Object o) {
        return this == o;
    }

    @Override
    int internHashCode() {
        return System.identityHashCode(this);
    }
}

