/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex.chart;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.chart.AllBenchmarks;
import org.jboss.jandex.chart.BenchmarksForVersion;
import org.jboss.jandex.json.BenchmarkDto;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;
import org.openjdk.jmh.annotations.Mode;

public class ChartGenerator {
    private static final Gson GSON = new Gson();

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        void var4_6;
        if (args.length == 0) {
            return;
        }
        ArrayList<BenchmarkDto[]> files = new ArrayList<BenchmarkDto[]>();
        String[] stringArray = args;
        int n = stringArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            String arg = stringArray[var4_6];
            BenchmarkDto[] file = Paths.get(arg, new String[0]);
            if (!Files.isRegularFile((Path)file, new LinkOption[0]) && !Files.isReadable((Path)file)) {
                throw new IllegalArgumentException("Can't read results file: " + file);
            }
            files.add(file);
            ++var4_6;
        }
        AllBenchmarks allBenchmarks = new AllBenchmarks();
        for (Path path : files) {
            String version = path.getFileName().toString().replace("results-", "").replace(".json", "");
            for (BenchmarkDto benchmark : ChartGenerator.readJson(path)) {
                allBenchmarks.add(version, benchmark);
            }
        }
        for (Map.Entry entry : allBenchmarks.map.entrySet()) {
            Mode mode = (Mode)entry.getKey();
            List allVersions = (List)entry.getValue();
            String unit = ChartGenerator.findCommonUnit(allVersions);
            CategoryChart chart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(1280)).height(1024)).title("Jandex Microbenchmarks")).xAxisTitle("Benchmark").yAxisTitle(mode.longLabel() + " (" + unit + ")").build();
            ((CategoryStyler)chart.getStyler()).setXAxisTicksVisible(true).setXAxisLabelRotation(45);
            for (BenchmarksForVersion benchmarksForVersion : allVersions) {
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<BigDecimal> scores = new ArrayList<BigDecimal>();
                ArrayList<BigDecimal> errors = new ArrayList<BigDecimal>();
                for (BenchmarkDto benchmark : benchmarksForVersion.benchmarks) {
                    names.add(benchmark.shortName());
                    scores.add(benchmark.primaryMetric.score);
                    errors.add(benchmark.primaryMetric.scoreError);
                }
                chart.addSeries(benchmarksForVersion.version, names, scores, errors);
            }
            BitmapEncoder.saveBitmap((Chart)chart, (String)("target/jandex-microbenchmarks-" + mode.shortLabel()), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
        }
    }

    private static BenchmarkDto[] readJson(Path inputFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(inputFile, StandardCharsets.UTF_8);){
            BenchmarkDto[] benchmarkDtoArray = (BenchmarkDto[])GSON.fromJson((Reader)reader, BenchmarkDto[].class);
            return benchmarkDtoArray;
        }
    }

    private static String findCommonUnit(List<BenchmarksForVersion> allVersions) {
        Set allUnits = allVersions.stream().flatMap(it -> it.benchmarks.stream()).map(it -> it.primaryMetric.scoreUnit).collect(Collectors.toSet());
        if (allUnits.size() != 1) {
            throw new IllegalStateException("Same mode benchmarks have different units: " + allUnits);
        }
        return (String)allUnits.iterator().next();
    }
}

