/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.zookeeper;

import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.config.source.zookeeper.ZooKeeperMessages;
import io.smallrye.config.source.zookeeper.ZooKeepperLogging;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = 3127679154588598693L;
    static final String ZOOKEEPER_URL_KEY = "io.smallrye.configsource.zookeeper.url";
    static final String APPLICATION_ID_KEY = "io.smallrye.configsource.zookeeper.applicationId";
    private static final String ZOOKEEPER_CONFIG_SOURCE_NAME = "io.smallrye.configsource.zookeeper";
    private final CuratorFramework curator;
    private final String applicationId;

    public ZooKeeperConfigSource(String zookeeperUrl, String applicationId) {
        super(ZOOKEEPER_CONFIG_SOURCE_NAME, 150);
        if (zookeeperUrl == null || applicationId == null) {
            throw ZooKeeperMessages.msg.propertiesNotSet();
        }
        ZooKeepperLogging.log.configuringZookeeper(zookeeperUrl, applicationId);
        this.applicationId = applicationId.startsWith("/") ? applicationId : "/" + applicationId;
        this.curator = CuratorFrameworkFactory.newClient((String)zookeeperUrl, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        this.curator.start();
    }

    public Set<String> getPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>();
        try {
            List children = (List)this.curator.getChildren().forPath(this.applicationId);
            propertyNames.addAll(children);
        }
        catch (Exception e) {
            ZooKeepperLogging.log.failedToRetrievePropertyNames(e);
        }
        return propertyNames;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        try {
            List children = (List)this.curator.getChildren().forPath(this.applicationId);
            for (String key : children) {
                String value = new String((byte[])this.curator.getData().forPath(this.applicationId + "/" + key));
                props.put(key, value);
            }
        }
        catch (Exception e) {
            ZooKeepperLogging.log.failedToRetrieveProperties(e);
        }
        return props;
    }

    public String getValue(String key) {
        try {
            Stat stat = (Stat)this.curator.checkExists().forPath(this.applicationId + "/" + key);
            if (stat != null) {
                return new String((byte[])this.curator.getData().forPath(this.applicationId + "/" + key));
            }
            return null;
        }
        catch (Exception e) {
            ZooKeepperLogging.log.failedToRetrieveValue(e, key);
            return null;
        }
    }
}

