/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingClassMapper;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.NameIterator;
import io.smallrye.config.PropertyName;
import io.smallrye.config.Secret;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config._private.ConfigMessages;
import io.smallrye.config.common.utils.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.Converter;

public final class ConfigMappingContext {
    private final SmallRyeConfig config;
    private final Map<Class<?>, Map<String, Object>> mappings = new IdentityHashMap();
    private final Map<Class<?>, Converter<?>> converterInstances = new IdentityHashMap();
    private ConfigMapping.NamingStrategy namingStrategy = ConfigMapping.NamingStrategy.KEBAB_CASE;
    private boolean beanStyleGetters = false;
    private final StringBuilder nameBuilder = new StringBuilder();
    private final Set<String> usedProperties = new HashSet<String>();
    private final List<ConfigValidationException.Problem> problems = new ArrayList<ConfigValidationException.Problem>();
    private static final Function<String, String> BEAN_STYLE_GETTERS = new Function<String, String>(){

        @Override
        public String apply(String name) {
            if (name.startsWith("get") && name.length() > 3) {
                return Character.toLowerCase(name.charAt(3)) + name.substring(4);
            }
            if (name.startsWith("is") && name.length() > 2) {
                return Character.toLowerCase(name.charAt(2)) + name.substring(3);
            }
            return name;
        }
    };

    public ConfigMappingContext(SmallRyeConfig config, SmallRyeConfigBuilder.MappingBuilder mappingBuilder) {
        Object instance;
        String prefix;
        Class<?> type;
        this.config = config;
        for (Map.Entry<ConfigMappings.ConfigClass, Object> entry : mappingBuilder.getMappingsInstances().entrySet()) {
            type = ConfigMappingLoader.getConfigMappingClass(entry.getKey().getType());
            prefix = entry.getKey().getPrefix();
            instance = entry.getValue();
            this.mappings.computeIfAbsent(type, k -> new HashMap(4)).put(prefix, instance);
        }
        for (ConfigMappings.ConfigClass configClass : mappingBuilder.getMappings()) {
            type = ConfigMappingLoader.getConfigMappingClass(configClass.getType());
            prefix = configClass.getPrefix();
            this.applyPrefix(configClass.getPrefix());
            instance = this.constructMapping(type, prefix);
            this.mappings.computeIfAbsent(type, k -> new HashMap(4)).put(prefix, instance);
        }
    }

    <T> T constructMapping(Class<T> interfaceType, String prefix) {
        int problemsCount = this.problems.size();
        Object mappingObject = this.constructGroup(interfaceType);
        if (problemsCount != this.problems.size()) {
            return (T)mappingObject;
        }
        try {
            if (mappingObject instanceof ConfigMappingClassMapper) {
                mappingObject = ((ConfigMappingClassMapper)mappingObject).map();
                this.config.getConfigValidator().validateMapping(mappingObject.getClass(), prefix, mappingObject);
            } else {
                this.config.getConfigValidator().validateMapping(interfaceType, prefix, mappingObject);
            }
        }
        catch (ConfigValidationException e) {
            this.problems.addAll(Arrays.asList(e.getProblems()));
        }
        return (T)mappingObject;
    }

    public <T> T constructGroup(Class<T> interfaceType) {
        ConfigMapping.NamingStrategy namingStrategy = this.namingStrategy;
        boolean beanStyleGetters = this.beanStyleGetters;
        T mappingObject = ConfigMappingLoader.configMappingObject(interfaceType, this);
        this.applyNamingStrategy(namingStrategy);
        this.applyBeanStyleGetters(beanStyleGetters);
        return mappingObject;
    }

    public <T> Converter<T> getConverterInstance(Class<? extends Converter<? extends T>> converterType) {
        return this.converterInstances.computeIfAbsent(converterType, t -> {
            try {
                return (Converter)t.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new InstantiationError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                try {
                    throw e.getCause();
                }
                catch (Error | RuntimeException e2) {
                    throw e2;
                }
                catch (Throwable t2) {
                    throw new UndeclaredThrowableException(t2);
                }
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
        });
    }

    public void applyPrefix(String prefix) {
        this.nameBuilder.replace(0, this.nameBuilder.length(), prefix);
    }

    public void applyNamingStrategy(ConfigMapping.NamingStrategy namingStrategy) {
        if (namingStrategy != null) {
            this.namingStrategy = namingStrategy;
        }
    }

    public void applyBeanStyleGetters(Boolean beanStyleGetters) {
        if (beanStyleGetters != null) {
            this.beanStyleGetters = beanStyleGetters;
        }
    }

    public Function<String, String> propertyName() {
        return this.beanStyleGetters ? BEAN_STYLE_GETTERS.andThen(this.namingStrategy) : this.namingStrategy;
    }

    public StringBuilder getNameBuilder() {
        return this.nameBuilder;
    }

    public void reportProblem(RuntimeException problem) {
        this.problems.add(new ConfigValidationException.Problem(problem.toString()));
    }

    List<ConfigValidationException.Problem> getProblems() {
        return this.problems;
    }

    Map<Class<?>, Map<String, Object>> getMappings() {
        return this.mappings;
    }

    void reportUnknown(Set<String> ignoredPaths) {
        HashSet<PropertyName> ignoredNames = new HashSet<PropertyName>();
        HashSet<String> ignoredPrefixes = new HashSet<String>();
        for (String ignoredPath : ignoredPaths) {
            if (ignoredPath.endsWith(".**")) {
                ignoredPrefixes.add(ignoredPath.substring(0, ignoredPath.length() - 3));
                continue;
            }
            ignoredNames.add(new PropertyName(ignoredPath));
        }
        HashSet<String> prefixes = new HashSet<String>();
        for (Map<String, Object> value : this.mappings.values()) {
            prefixes.addAll(value.keySet());
        }
        if (prefixes.contains("")) {
            prefixes.clear();
        }
        block2: for (String propertyName : this.config.getPropertyNames()) {
            if (this.usedProperties.contains(propertyName) || ignoredNames.contains(new PropertyName(propertyName))) continue;
            for (String ignoredPrefix : ignoredPrefixes) {
                if (!propertyName.startsWith(ignoredPrefix)) continue;
                continue block2;
            }
            for (String prefix : prefixes) {
                ConfigValue configValue;
                if (!ConfigMappingContext.isPropertyInRoot(propertyName, prefix) || (configValue = this.config.getConfigValue(propertyName)).getSourceName() != null && configValue.getSourceName().startsWith("EnvConfigSource")) continue;
                this.problems.add(new ConfigValidationException.Problem(ConfigMessages.msg.propertyDoesNotMapToAnyRoot(propertyName, configValue.getLocation())));
            }
        }
    }

    private static boolean isPropertyInRoot(String property, String root) {
        if (property.equals(root)) {
            return true;
        }
        if (property.length() <= root.length()) {
            return false;
        }
        char c = property.charAt(root.length());
        if (c == '.' || c == '[') {
            return property.startsWith(root);
        }
        return false;
    }

    static class MapWithDefault<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1390928078837140814L;
        private final V defaultValue;

        MapWithDefault(V defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public V get(Object key) {
            return this.getOrDefault(key, this.defaultValue);
        }
    }

    public class ObjectCreator<T> {
        private T root;
        private List<Consumer<Function<String, Object>>> creators;

        public ObjectCreator(final String path) {
            this.creators = List.of(new Consumer<Function<String, Object>>(){

                @Override
                public void accept(Function<String, Object> get) {
                    ObjectCreator.this.root = get.apply(path);
                }
            });
        }

        public <K> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith) {
            return this.map(keyRawType, keyConvertWith, null, Collections.emptyList());
        }

        public <K> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, String unnamedKey, Iterable<String> keys) {
            return this.map(keyRawType, keyConvertWith, unnamedKey, keys, (Class)null);
        }

        public <K, V> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, String unnamedKey, Iterable<String> keys, final Class<V> defaultClass) {
            Supplier supplier = null;
            if (defaultClass != null) {
                supplier = new Supplier<V>(){

                    @Override
                    public V get() {
                        int length = ConfigMappingContext.this.nameBuilder.length();
                        ConfigMappingContext.this.nameBuilder.append(".*");
                        Object defaultValue = ConfigMappingContext.this.constructGroup(defaultClass);
                        ConfigMappingContext.this.nameBuilder.setLength(length);
                        return defaultValue;
                    }
                };
            }
            return this.map(keyRawType, keyConvertWith, unnamedKey, keys, supplier);
        }

        public <K, V> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, final String unnamedKey, final Iterable<String> keys, final Supplier<V> defaultValue) {
            final Object keyConverter = keyConvertWith == null ? ConfigMappingContext.this.config.requireConverter(keyRawType) : ConfigMappingContext.this.getConverterInstance(keyConvertWith);
            final ArrayList<Consumer<Function<String, Object>>> nestedCreators = new ArrayList<Consumer<Function<String, Object>>>();
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(final String path) {
                        HashMap map;
                        HashMap hashMap = map = defaultValue != null ? new MapWithDefault(defaultValue.get()) : new HashMap();
                        if (unnamedKey != null) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    Object value = get.apply(path);
                                    if (value != null) {
                                        map.put(unnamedKey.isEmpty() ? null : keyConverter.convert(unnamedKey), value);
                                    }
                                }
                            });
                        }
                        HashMap<String, String> mapKeys = new HashMap<String, String>();
                        final HashMap<String, List<String>> mapProperties = new HashMap<String, List<String>>();
                        if (keys != null) {
                            for (String string : keys) {
                                if (string.isEmpty()) {
                                    mapKeys.put(string, path);
                                    continue;
                                }
                                mapKeys.put(string, path + "." + ObjectCreator.quoted(string));
                            }
                        }
                        if (mapKeys.isEmpty()) {
                            for (final String string : ConfigMappingContext.this.config.getPropertyNames()) {
                                if (string.length() <= path.length() + 1 || !path.isEmpty() && string.charAt(path.length()) != '.' || !string.startsWith(path)) continue;
                                final NameIterator mapProperty = !path.isEmpty() ? new NameIterator(StringUtil.unindexed((String)string), path.length()) : new NameIterator(StringUtil.unindexed((String)string));
                                mapProperty.next();
                                String mapKey = StringUtil.unindexed((String)mapProperty.getPreviousSegment());
                                mapKeys.computeIfAbsent(mapKey, new Function<String, String>(){

                                    @Override
                                    public String apply(String s) {
                                        return StringUtil.unindexed((String)string.substring(0, mapProperty.getPosition()));
                                    }
                                });
                                mapProperties.computeIfAbsent(mapKey, new Function<String, List<String>>(){

                                    @Override
                                    public List<String> apply(String s) {
                                        return new ArrayList<String>();
                                    }
                                });
                                ((List)mapProperties.get(mapKey)).add(string);
                            }
                        }
                        for (final Map.Entry entry : mapKeys.entrySet()) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    Object value;
                                    if (unnamedKey != null && !unnamedKey.isEmpty() && !mapProperties.isEmpty()) {
                                        boolean allUsed = true;
                                        for (String mapProperty : (List)mapProperties.get(entry.getKey())) {
                                            if (ConfigMappingContext.this.usedProperties.contains(mapProperty)) continue;
                                            allUsed = false;
                                            break;
                                        }
                                        if (allUsed) {
                                            return;
                                        }
                                    }
                                    if ((value = get.apply((String)entry.getValue())) != null) {
                                        map.put(keyConverter.convert((String)entry.getKey()), value);
                                    }
                                }
                            });
                        }
                        return map;
                    }
                });
            }
            this.creators = nestedCreators;
            return this;
        }

        public <V, C extends Collection<V>> ObjectCreator<T> collection(Class<C> collectionRawType) {
            final ArrayList<Consumer<Function<String, Object>>> nestedCreators = new ArrayList<Consumer<Function<String, Object>>>();
            IntFunction<Collection<C>> collectionFactory = ObjectCreator.createCollectionFactory(collectionRawType);
            for (Consumer<Function<String, Object>> creator : this.creators) {
                final Collection<C> collection = collectionFactory.apply(0);
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(final String path) {
                        for (final Integer index : ConfigMappingContext.this.config.getIndexedPropertiesIndexes(path)) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    collection.add(get.apply(path + "[" + index + "]"));
                                }
                            });
                        }
                        return collection;
                    }
                });
            }
            this.creators = nestedCreators;
            return this;
        }

        public <V, C extends Collection<V>> ObjectCreator<T> optionalCollection(Class<C> collectionRawType) {
            final ArrayList<Consumer<Function<String, Object>>> nestedCreators = new ArrayList<Consumer<Function<String, Object>>>();
            IntFunction<Collection<C>> collectionFactory = ObjectCreator.createCollectionFactory(collectionRawType);
            for (Consumer<Function<String, Object>> creator : this.creators) {
                final Collection<C> collection = collectionFactory.apply(0);
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(final String path) {
                        List<Integer> indexes = ConfigMappingContext.this.config.getIndexedPropertiesIndexes(path);
                        for (final Integer index : indexes) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    collection.add(get.apply(path + "[" + index + "]"));
                                }
                            });
                        }
                        return indexes.isEmpty() ? Optional.empty() : Optional.of(collection);
                    }
                });
            }
            this.creators = nestedCreators;
            return this;
        }

        public <G> ObjectCreator<T> group(final Class<G> groupType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public G apply(String path) {
                        StringBuilder sb = ConfigMappingContext.this.getNameBuilder();
                        int length = sb.length();
                        sb.append(path, length, path.length());
                        Object group = ConfigMappingContext.this.constructGroup(groupType);
                        sb.setLength(length);
                        return group;
                    }
                });
            }
            return this;
        }

        public <G> ObjectCreator<T> lazyGroup(final Class<G> groupType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public G apply(String path) {
                        if (ObjectCreator.this.createRequired(groupType, path)) {
                            StringBuilder sb = ConfigMappingContext.this.getNameBuilder();
                            int length = sb.length();
                            sb.append(path, length, path.length());
                            Object group = ConfigMappingContext.this.constructGroup(groupType);
                            sb.setLength(length);
                            return group;
                        }
                        return null;
                    }
                });
            }
            return this;
        }

        public <G> ObjectCreator<T> optionalGroup(final Class<G> groupType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Optional<G> apply(String path) {
                        if (ObjectCreator.this.createRequired(groupType, path)) {
                            StringBuilder sb = ConfigMappingContext.this.getNameBuilder();
                            int length = sb.length();
                            sb.append(path, length, path.length());
                            Object group = ConfigMappingContext.this.constructGroup(groupType);
                            sb.setLength(length);
                            return Optional.of(group);
                        }
                        return Optional.empty();
                    }
                });
            }
            return this;
        }

        public static <V> V value(ConfigMappingContext context, String propertyName, Class<V> valueRawType, Class<? extends Converter<V>> valueConvertWith) {
            return ObjectCreator.convertValue(context, propertyName, ObjectCreator.getConverter(context, valueRawType, valueConvertWith));
        }

        public static <V> Secret<V> secretValue(ConfigMappingContext context, String propertyName, Class<V> valueRawType, Class<? extends Converter<V>> valueConvertWith) {
            Converter<Secret<V>> valueConverter = Converters.newSecretConverter(ObjectCreator.getConverter(context, valueRawType, valueConvertWith));
            return ObjectCreator.convertValue(context, propertyName, valueConverter);
        }

        private static <V> V convertValue(ConfigMappingContext context, String propertyName, Converter<V> valueConverter) {
            context.usedProperties.add(propertyName);
            return context.config.getValue(propertyName, valueConverter);
        }

        public ObjectCreator<T> value(final Class<T> valueRawType, final Class<? extends Converter<T>> valueConvertWith) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(String propertyName) {
                        return ObjectCreator.value(ConfigMappingContext.this, propertyName, valueRawType, valueConvertWith);
                    }
                });
            }
            return this;
        }

        public static <V> Optional<V> optionalValue(ConfigMappingContext context, String propertyName, Class<V> valueRawType, Class<? extends Converter<V>> valueConvertWith) {
            return ObjectCreator.convertOptionalValue(context, propertyName, ObjectCreator.getConverter(context, valueRawType, valueConvertWith));
        }

        public static <V> Optional<Secret<V>> optionalSecretValue(ConfigMappingContext context, String propertyName, Class<V> valueRawType, Class<? extends Converter<V>> valueConvertWith) {
            Converter<Optional<Secret<V>>> valueConverter = Converters.newOptionalConverter(Converters.newSecretConverter(ObjectCreator.getConverter(context, valueRawType, valueConvertWith)));
            return ObjectCreator.convertValue(context, propertyName, valueConverter);
        }

        private static <V> Optional<V> convertOptionalValue(ConfigMappingContext context, String propertyName, Converter<V> valueConverter) {
            context.usedProperties.add(propertyName);
            return context.config.getOptionalValue(propertyName, valueConverter);
        }

        public <V> ObjectCreator<T> optionalValue(final Class<V> valueRawType, final Class<? extends Converter<V>> valueConvertWith) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Optional<V> apply(String propertyName) {
                        return ObjectCreator.optionalValue(ConfigMappingContext.this, propertyName, valueRawType, valueConvertWith);
                    }
                });
            }
            return this;
        }

        public static <V, C extends Collection<V>> C values(ConfigMappingContext context, String propertyName, Class<V> itemRawType, Class<? extends Converter<V>> itemConvertWith, Class<C> collectionRawType) {
            Converter<V> itemConverter = ObjectCreator.getConverter(context, itemRawType, itemConvertWith);
            return ObjectCreator.convertValues(context, propertyName, itemConverter, collectionRawType);
        }

        public static <V, C extends Collection<Secret<V>>> C secretValues(ConfigMappingContext context, String propertyName, Class<V> itemRawType, Class<? extends Converter<V>> itemConvertWith, Class<C> collectionRawType) {
            Converter<Secret<V>> itemConverter = Converters.newSecretConverter(ObjectCreator.getConverter(context, itemRawType, itemConvertWith));
            return ObjectCreator.convertValues(context, propertyName, itemConverter, collectionRawType);
        }

        public static <V, C extends Collection<V>> C convertValues(ConfigMappingContext context, String propertyName, Converter<V> itemConverter, Class<C> collectionRawType) {
            context.usedProperties.add(propertyName);
            context.usedProperties.addAll(context.config.getIndexedProperties(propertyName));
            IntFunction<Collection<C>> collectionFactory = ObjectCreator.createCollectionFactory(collectionRawType);
            return (C)context.config.getValues(propertyName, itemConverter, collectionFactory);
        }

        public <V, C extends Collection<V>> ObjectCreator<T> values(final Class<V> itemRawType, final Class<? extends Converter<V>> itemConvertWith, final Class<C> collectionRawType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(String propertyName) {
                        return ObjectCreator.values(ConfigMappingContext.this, propertyName, itemRawType, itemConvertWith, collectionRawType);
                    }
                });
            }
            return this;
        }

        public static <V, C extends Collection<V>> Optional<C> optionalValues(ConfigMappingContext context, String propertyName, Class<V> itemRawType, Class<? extends Converter<V>> itemConvertWith, Class<C> collectionRawType) {
            Converter<V> itemConverter = ObjectCreator.getConverter(context, itemRawType, itemConvertWith);
            return ObjectCreator.convertOptionalValues(context, propertyName, itemConverter, collectionRawType);
        }

        public static <V, C extends Collection<Secret<V>>> Optional<C> optionalSecretValues(ConfigMappingContext context, String propertyName, Class<V> itemRawType, Class<? extends Converter<V>> itemConvertWith, Class<C> collectionRawType) {
            Converter<Secret<V>> itemConverter = Converters.newSecretConverter(ObjectCreator.getConverter(context, itemRawType, itemConvertWith));
            return ObjectCreator.convertOptionalValues(context, propertyName, itemConverter, collectionRawType);
        }

        public static <V, C extends Collection<V>> Optional<C> convertOptionalValues(ConfigMappingContext context, String propertyName, Converter<V> itemConverter, Class<C> collectionRawType) {
            context.usedProperties.add(propertyName);
            context.usedProperties.addAll(context.config.getIndexedProperties(propertyName));
            IntFunction<Collection<C>> collectionFactory = ObjectCreator.createCollectionFactory(collectionRawType);
            return context.config.getOptionalValues(propertyName, itemConverter, collectionFactory);
        }

        public <V, C extends Collection<V>> ObjectCreator<T> optionalValues(final Class<V> itemRawType, final Class<? extends Converter<V>> itemConvertWith, final Class<C> collectionRawType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(String propertyName) {
                        return ObjectCreator.optionalValues(ConfigMappingContext.this, propertyName, itemRawType, itemConvertWith, collectionRawType);
                    }
                });
            }
            return this;
        }

        public static <K, V> Map<K, V> values(ConfigMappingContext context, String propertyName, Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, Class<V> valueRawType, Class<? extends Converter<V>> valueConvertWith, Iterable<String> keys, String defaultValue) {
            Converter<K> keyConverter = ObjectCreator.getConverter(context, keyRawType, keyConvertWith);
            Converter<V> valueConverter = ObjectCreator.getConverter(context, valueRawType, valueConvertWith);
            return ObjectCreator.convertValues(context, propertyName, keyConverter, valueConverter, keys, defaultValue);
        }

        public static <K, V> Map<K, Secret<V>> secretValues(ConfigMappingContext context, String propertyName, Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, Class<V> valueRawType, Class<? extends Converter<V>> valueConvertWith, Iterable<String> keys, String defaultValue) {
            Converter<K> keyConverter = ObjectCreator.getConverter(context, keyRawType, keyConvertWith);
            Converter<Secret<V>> valueConverter = Converters.newSecretConverter(ObjectCreator.getConverter(context, valueRawType, valueConvertWith));
            return ObjectCreator.convertValues(context, propertyName, keyConverter, valueConverter, keys, defaultValue);
        }

        public static <K, V> Map<K, V> convertValues(ConfigMappingContext context, String propertyName, Converter<K> keyConverter, final Converter<V> valueConverter, Iterable<String> keys, final String defaultValue) {
            Map<Object, Object> mapKeys = new HashMap();
            if (keys != null) {
                for (String key : keys) {
                    mapKeys.put(key, propertyName + "." + ObjectCreator.quoted(key));
                }
            }
            if (mapKeys.isEmpty()) {
                mapKeys = context.config.getMapKeys(propertyName);
            }
            IntFunction mapFactory = defaultValue != null ? new IntFunction<Map<K, V>>(){

                @Override
                public Map<K, V> apply(int value) {
                    return new MapWithDefault(valueConverter.convert(defaultValue));
                }
            } : new IntFunction<Map<K, V>>(){

                @Override
                public Map<K, V> apply(int size) {
                    return new HashMap(size);
                }
            };
            context.usedProperties.add(propertyName);
            context.usedProperties.addAll(mapKeys.values());
            return context.config.getMapValues(mapKeys, keyConverter, valueConverter, mapFactory);
        }

        public <K, V> ObjectCreator<T> values(final Class<K> keyRawType, final Class<? extends Converter<K>> keyConvertWith, final Class<V> valueRawType, final Class<? extends Converter<V>> valueConvertWith, final Iterable<String> keys, final String defaultValue) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(String propertyName) {
                        return ObjectCreator.values(ConfigMappingContext.this, propertyName, keyRawType, keyConvertWith, valueRawType, valueConvertWith, keys, defaultValue);
                    }
                });
            }
            return this;
        }

        public static <K, V, C extends Collection<V>> Map<K, C> values(ConfigMappingContext context, String propertyName, Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, Class<V> valueRawType, Class<? extends Converter<V>> valueConvertWith, Class<C> collectionRawType, Iterable<String> keys, String defaultValue) {
            Converter<K> keyConverter = ObjectCreator.getConverter(context, keyRawType, keyConvertWith);
            Converter<V> valueConverter = ObjectCreator.getConverter(context, valueRawType, valueConvertWith);
            return ObjectCreator.convertValues(context, propertyName, keyConverter, valueConverter, collectionRawType, keys, defaultValue);
        }

        public static <K, V, C extends Collection<Secret<V>>> Map<K, C> secretValues(ConfigMappingContext context, String propertyName, Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, Class<V> valueRawType, Class<? extends Converter<V>> valueConvertWith, Class<C> collectionRawType, Iterable<String> keys, String defaultValue) {
            Converter<K> keyConverter = ObjectCreator.getConverter(context, keyRawType, keyConvertWith);
            Converter<Secret<V>> valueConverter = Converters.newSecretConverter(ObjectCreator.getConverter(context, valueRawType, valueConvertWith));
            return ObjectCreator.convertValues(context, propertyName, keyConverter, valueConverter, collectionRawType, keys, defaultValue);
        }

        public static <K, V, C extends Collection<V>> Map<K, C> convertValues(ConfigMappingContext context, String propertyName, Converter<K> keyConverter, final Converter<V> valueConverter, Class<C> collectionRawType, Iterable<String> keys, final String defaultValue) {
            Map<Object, Object> mapKeys = new HashMap();
            if (keys != null) {
                for (String key : keys) {
                    mapKeys.put(key, propertyName + "." + ObjectCreator.quoted(key));
                }
            }
            if (mapKeys.isEmpty()) {
                mapKeys = context.config.getMapIndexedKeys(propertyName);
            }
            final IntFunction<Collection<C>> collectionFactory = ObjectCreator.createCollectionFactory(collectionRawType);
            IntFunction mapFactory = defaultValue != null ? new IntFunction<Map<K, C>>(){

                @Override
                public Map<K, C> apply(int value) {
                    return new MapWithDefault((Collection)Converters.newCollectionConverter(valueConverter, collectionFactory).convert(defaultValue));
                }
            } : new IntFunction<Map<K, C>>(){

                @Override
                public Map<K, C> apply(int size) {
                    return new HashMap(size);
                }
            };
            context.usedProperties.add(propertyName);
            context.usedProperties.addAll(mapKeys.values());
            context.usedProperties.addAll(context.config.getMapKeys(propertyName).values());
            return context.config.getMapIndexedValues(mapKeys, keyConverter, valueConverter, mapFactory, collectionFactory);
        }

        public <K, V, C extends Collection<V>> ObjectCreator<T> values(final Class<K> keyRawType, final Class<? extends Converter<K>> keyConvertWith, final Class<V> valueRawType, final Class<? extends Converter<V>> valueConvertWith, final Class<C> collectionRawType, final Iterable<String> keys, final String defaultValue) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(String propertyName) {
                        return ObjectCreator.values(ConfigMappingContext.this, propertyName, keyRawType, keyConvertWith, valueRawType, valueConvertWith, collectionRawType, keys, defaultValue);
                    }
                });
            }
            return this;
        }

        public T get() {
            return this.root;
        }

        private <G> boolean createRequired(Class<G> groupType, String path) {
            ArrayList<String> candidates = new ArrayList<String>();
            for (String name : ConfigMappingContext.this.config.getPropertyNames()) {
                String candidate;
                if (!name.startsWith(path)) continue;
                String string = candidate = name.length() > path.length() && name.charAt(path.length()) == '.' ? name.substring(path.length() + 1) : name.substring(path.length());
                if (ConfigMappingContext.this.namingStrategy.equals(ConfigMapping.NamingStrategy.KEBAB_CASE)) {
                    candidates.add(candidate);
                    continue;
                }
                candidates.add(ConfigMapping.NamingStrategy.KEBAB_CASE.apply(candidate));
            }
            if (!candidates.isEmpty()) {
                Map<String, String> properties = ConfigMappingLoader.configMappingProperties(groupType);
                for (String mappedProperty : properties.keySet()) {
                    for (String candidate : candidates) {
                        if (!PropertyName.equals(candidate, mappedProperty)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private static <V> Converter<V> getConverter(ConfigMappingContext context, Class<V> rawType, Class<? extends Converter<V>> convertWith) {
            return convertWith == null ? context.config.requireConverter(rawType) : context.getConverterInstance(convertWith);
        }

        private static IntFunction<Collection<?>> createCollectionFactory(Class<?> type) {
            if (type == List.class) {
                return ArrayList::new;
            }
            if (type == Set.class) {
                return HashSet::new;
            }
            throw new IllegalArgumentException();
        }

        private static String quoted(String key) {
            NameIterator keyIterator = new NameIterator(key);
            keyIterator.next();
            return keyIterator.hasNext() ? "\"" + key + "\"" : key;
        }
    }
}

