/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.os.OS;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;

public final class ProcessUtil {
    private ProcessUtil() {
    }

    public static void destroyAllForcibly(ProcessHandle handle) {
        for (ProcessHandle processHandle : handle.children().toList()) {
            ProcessUtil.destroyAllForcibly(processHandle);
        }
        handle.destroyForcibly();
    }

    public static Optional<Path> pathOfCommand(Path path) {
        Path execPath;
        Assert.checkNotNullParam((String)"path", (Object)path);
        if (path.isAbsolute()) {
            return Files.isExecutable(path) ? Optional.of(path) : Optional.empty();
        }
        String pathEnv = System.getenv("PATH");
        for (String segment : pathEnv.split(Pattern.quote(File.pathSeparator))) {
            if (segment.isEmpty() || !Files.isExecutable(execPath = Path.of(segment, new String[0]).resolve(path))) continue;
            return Optional.of(execPath);
        }
        if (OS.current() == OS.WINDOWS) {
            pathEnv = System.getenv("PATHEXT");
            for (String segment : pathEnv.split(Pattern.quote(File.pathSeparator))) {
                if (segment.isEmpty() || !Files.isExecutable(execPath = Path.of(segment, new String[0]).resolve(path))) continue;
                return Optional.of(execPath);
            }
        }
        return Optional.empty();
    }

    public static Path pathOfJava() {
        return JavaPath.path;
    }

    public static String nameOfJava() {
        return JavaPath.javaName;
    }

    public static boolean stillRunningAfter(Process proc, long nanos) {
        boolean intr = false;
        try {
            long start = System.nanoTime();
            if (nanos <= 0L) {
                boolean bl = proc.isAlive();
                return bl;
            }
            boolean bl = !proc.waitFor(nanos, TimeUnit.NANOSECONDS);
            return bl;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean stillRunningAfter(ProcessHandle proc, long nanos) {
        boolean intr = false;
        try {
            long start = System.nanoTime();
            while (true) {
                if (nanos <= 0L) {
                    boolean bl = proc.isAlive();
                    return bl;
                }
                try {
                    proc.onExit().get(nanos, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException ignored) {
                    intr = true;
                }
                catch (ExecutionException | TimeoutException exception) {
                    // empty catch block
                }
                long l = -start;
                start = System.nanoTime();
                nanos -= l + start;
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class JavaPath {
        private static final String javaName = OS.current() == OS.WINDOWS ? "java.exe" : "java";
        private static final Path path;

        private JavaPath() {
        }

        static {
            Path javaPath = null;
            Optional<String> javaCommand = ProcessHandle.current().info().command();
            if (javaCommand.isPresent()) {
                javaPath = Path.of(javaCommand.get(), new String[0]);
            }
            if (javaPath == null) {
                String javaHome = System.getProperty("java.home");
                if (javaHome == null) {
                    javaHome = System.getenv("JAVA_HOME");
                }
                if (javaHome != null && !Files.isExecutable(javaPath = Path.of(javaHome, "bin", javaName))) {
                    javaPath = null;
                }
            }
            Path javaRelativePath = Path.of(javaName, new String[0]);
            if (javaPath == null) {
                javaPath = ProcessUtil.pathOfCommand(javaRelativePath).orElse(javaRelativePath);
            }
            path = javaPath;
        }
    }
}

