/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.process.Logging;
import io.smallrye.common.process.PipelineExecutionException;
import io.smallrye.common.process.PipelineRunner;
import io.smallrye.common.process.ProcessBuilderImpl;
import io.smallrye.common.process.ProcessExecutionException;
import io.smallrye.common.process.ProcessHandlerException;
import java.io.IOException;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.LockSupport;

final class ProcessRunner<O>
extends PipelineRunner<O> {
    private static final VarHandle taskCountHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "taskCount", VarHandle.class, MethodHandles.lookup().lookupClass(), Integer.TYPE);
    private static final int STATUS_WAITING = 0;
    private static final int STATUS_STARTED = 1;
    private static final int STATUS_FAILED = 2;
    private final CopyOnWriteArraySet<Thread> waiters = new CopyOnWriteArraySet<Thread>(List.of(Thread.currentThread()));
    private volatile int status;
    private Thread outputThread;
    private ProcessHandlerException outputProblem;
    private O result;
    private volatile int taskCount;

    ProcessRunner(ProcessBuilderImpl<O> processBuilder, PipelineRunner<?> prev) {
        super(processBuilder, prev);
    }

    @Override
    void startThreads() {
        ProcessRunner.startThread(this.outputThread);
        super.startThreads();
    }

    void taskComplete() {
        int oldVal = taskCountHandle.getAndAdd(this, -1);
        if (oldVal == 1) {
            this.waiters.removeIf(thread -> {
                LockSupport.unpark(thread);
                return true;
            });
        }
    }

    @Override
    int createThreads(ThreadFactory tf, ProcessRunner<?> runner) throws IOException {
        return super.createThreads(tf, runner) + this.createOutputThread(tf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    O run() {
        int taskCnt;
        ThreadFactory tf = task -> new Thread(() -> {
            Logging.log.trace("Starting process thread");
            try {
                task.run();
            }
            finally {
                Logging.log.trace("Ending process thread");
            }
        });
        try {
            taskCnt = this.createThreads(tf, this);
        }
        catch (IOException e) {
            throw new PipelineExecutionException("Failed to create process thread(s)", e);
        }
        try {
            this.startThreads();
        }
        catch (Throwable t) {
            this.status = 2;
            this.unpark();
            throw new PipelineExecutionException("Failed to start process thread(s)", t);
        }
        try {
            ProcessBuilder[] array = new ProcessBuilder[this.processBuilder.depth];
            this.assembleBuilders(array);
            List<Process> processes = ProcessBuilder.startPipeline(List.of(array));
            this.setProcesses(processes);
            this.taskCount = taskCnt;
        }
        catch (Throwable t) {
            this.status = 2;
            this.unpark();
            throw new PipelineExecutionException("Failed to start process pipeline", t);
        }
        this.status = 1;
        this.unpark();
        Thread shutdownHook = new Thread(() -> {
            int cnt = taskCnt;
            if (cnt != 0) {
                this.waiters.add(Thread.currentThread());
                do {
                    Thread.interrupted();
                    LockSupport.park(this);
                } while ((cnt = this.taskCount) != 0);
            }
        }, "process-shutdown-\"%s\"-%d".formatted(this.processBuilder.command, this.process.pid()));
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        try {
            int cnt = taskCnt;
            while (cnt != 0) {
                Thread.interrupted();
                LockSupport.park(this);
                cnt = this.taskCount;
            }
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        ArrayList<ProcessExecutionException> problems = new ArrayList<ProcessExecutionException>(4);
        this.collectProblems(problems);
        switch (problems.size()) {
            case 0: {
                break;
            }
            case 1: {
                throw (ProcessExecutionException)problems.get(0);
            }
            default: {
                PipelineExecutionException ex = new PipelineExecutionException("Pipeline execution failed");
                problems.forEach(ex::addSuppressed);
                throw ex;
            }
        }
        return this.result;
    }

    void collectProblems(List<ProcessExecutionException> problems) {
        this.collectProblems(problems, this.outputProblem);
    }

    int createOutputThread(ThreadFactory tf) throws IOException {
        if (this.processBuilder.outputHandler != null) {
            this.outputThread = tf.newThread(() -> {
                if (this.awaitOk()) {
                    Thread.currentThread().setName("process-output-\"%s\"-%d".formatted(this.processBuilder.command, this.process.pid()));
                    try {
                        this.result = this.processBuilder.outputHandler.apply((Object)this.process);
                    }
                    catch (ProcessHandlerException phe) {
                        this.outputProblem = phe;
                    }
                    catch (Throwable t) {
                        this.outputProblem = new ProcessHandlerException("Output processing failed due to exception", t);
                    }
                    finally {
                        this.ioDone(2);
                        this.taskComplete();
                    }
                }
            });
            if (this.outputThread == null) {
                throw ProcessRunner.noThread(tf);
            }
            this.outputThread.setName("process-output-\"%s\"-???".formatted(this.processBuilder.command));
            this.ioRegistered(2);
            return 1;
        }
        return 0;
    }

    @Override
    void unpark() {
        LockSupport.unpark(this.outputThread);
        super.unpark();
    }

    boolean awaitOk() {
        while (this.status == 0) {
            LockSupport.park(this.processBuilder);
        }
        return this.status == 1;
    }
}

