/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Consumer;

final class LineProcessor {
    private final BufferedReader reader;
    private final int lengthLimit;
    private final Consumer<Object> consumer;
    static final Object EOF = new Object();

    public LineProcessor(Reader reader, int lengthLimit, Consumer<Object> consumer) {
        BufferedReader br;
        this.reader = reader instanceof BufferedReader ? (br = (BufferedReader)reader) : new BufferedReader(reader);
        this.lengthLimit = lengthLimit;
        this.consumer = consumer;
    }

    public void run() throws IOException {
        StringBuilder sb = new StringBuilder(Math.min(this.lengthLimit, 128));
        int charCnt = 0;
        boolean skipping = false;
        boolean gotCr = false;
        block7: while (true) {
            int c;
            try {
                c = this.reader.read();
            }
            catch (IOException e) {
                sb.setLength(0);
                this.consumer.accept(e);
                throw e;
            }
            switch (c) {
                case -1: {
                    if (!sb.isEmpty()) {
                        this.consumer.accept(sb.toString());
                        sb.setLength(0);
                    }
                    this.consumer.accept(EOF);
                    return;
                }
                case 13: {
                    gotCr = true;
                    this.consumer.accept(sb.toString());
                    sb.setLength(0);
                    skipping = false;
                    charCnt = 0;
                    continue block7;
                }
                case 10: {
                    if (gotCr) {
                        gotCr = false;
                        continue block7;
                    }
                    this.consumer.accept(sb.toString());
                    sb.setLength(0);
                    skipping = false;
                    charCnt = 0;
                    continue block7;
                }
            }
            gotCr = false;
            if (skipping) continue;
            if (charCnt == this.lengthLimit) {
                skipping = true;
                sb.append('\u2026');
                continue;
            }
            ++charCnt;
            sb.append((char)c);
        }
    }
}

