/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import io.skygear.skygear.Error;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorSerializer {
    public static JSONObject serialize(Error errorObject) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("message", (Object)errorObject.getDetailMessage());
            jsonObject.put("code", errorObject.getCodeValue());
            jsonObject.put("name", (Object)errorObject.getName());
            JSONObject infoObject = errorObject.getInfo();
            if (infoObject != null) {
                jsonObject.put("info", (Object)infoObject);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Error deserialize(JSONObject jsonObject) throws JSONException {
        String errorString = jsonObject.optString("message");
        int errorCodeValue = jsonObject.getInt("code");
        String errorName = jsonObject.optString("name");
        JSONObject errorInfo = jsonObject.optJSONObject("info");
        return new Error(errorCodeValue, errorName, errorString, errorInfo);
    }
}

