/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.util.Base64;
import io.skygear.skygear.Asset;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageAssetSerializer {
    public static JSONObject serialize(Asset asset) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("$type", (Object)"asset");
            jsonObject.put("$name", (Object)asset.getName());
            jsonObject.put("$content_type", (Object)asset.getMimeType());
            if (asset.getUrl() != null) {
                jsonObject.put("$url", (Object)asset.getUrl());
            }
            if (asset.getData() != null) {
                jsonObject.put("data", (Object)Base64.encodeToString((byte[])asset.getData(), (int)0));
            }
            return jsonObject;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Asset deserialize(JSONObject assetJSONObject) throws JSONException {
        String typeValue = assetJSONObject.getString("$type");
        if (typeValue.equals("asset")) {
            String assetName = assetJSONObject.getString("$name");
            String assetMimeType = assetJSONObject.getString("$content_type");
            if (assetJSONObject.has("data")) {
                byte[] data = Base64.decode((String)assetJSONObject.getString("data"), (int)0);
                return new Asset(assetName, assetMimeType, data);
            }
            String assetUrl = assetJSONObject.optString("$url", null);
            return new Asset(assetName, assetUrl, assetMimeType);
        }
        throw new JSONException("Invalid $type value: " + typeValue);
    }
}

