/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.skygear.plugins.chat.MessageAssetSerializer;
import io.skygear.skygear.Asset;
import io.skygear.skygear.Record;
import io.skygear.skygear.Reference;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Message {
    static final String TYPE_KEY = "message";
    static final String BODY_KEY = "body";
    static final String METADATA_KEY = "metadata";
    static final String ATTACHMENT_KEY = "attachment";
    static final String MESSAGE_STATUS_KEY = "message_status";
    static final String SEQ_KEY = "seq";
    final Record record;
    Date sendDate;

    public Message() {
        this.record = new Record(TYPE_KEY);
    }

    public Message(@NonNull Record record) {
        this.record = record;
    }

    @NonNull
    public String getId() {
        return this.record.getId();
    }

    @NonNull
    public String getConversationId() {
        Reference reference = (Reference)this.record.get("conversation");
        return reference.getId();
    }

    public void setBody(String body) {
        this.record.set(BODY_KEY, (Object)body);
    }

    @Nullable
    public String getBody() {
        return (String)this.record.get(BODY_KEY);
    }

    @Nullable
    public void setMetadata(JSONObject metadata) {
        this.record.set(METADATA_KEY, (Object)metadata);
    }

    @Nullable
    public JSONObject getMetadata() {
        if (!this.record.get(METADATA_KEY).equals(JSONObject.NULL)) {
            return (JSONObject)this.record.get(METADATA_KEY);
        }
        return null;
    }

    @Nullable
    public Status getStatus() {
        return Status.fromName((String)this.record.get(MESSAGE_STATUS_KEY));
    }

    @NonNull
    public Date getCreatedTime() {
        return this.record.getCreatedAt();
    }

    @NonNull
    public Date getUpdatedTime() {
        return this.record.getUpdatedAt();
    }

    @Nullable
    public void setAsset(Asset asset) {
        this.record.set(ATTACHMENT_KEY, (Object)asset);
    }

    @Nullable
    public Asset getAsset() {
        return (Asset)this.record.get(ATTACHMENT_KEY);
    }

    public boolean isDeleted() {
        return (Boolean)this.record.get("deleted");
    }

    public Date getSendDate() {
        return this.sendDate;
    }

    @NonNull
    public int getSequence() {
        Object value = this.record.get(SEQ_KEY);
        return value == null ? 0 : (Integer)value;
    }

    public Record getRecord() {
        return this.record;
    }

    @NonNull
    static Reference newReference(@NonNull String messageId) {
        return new Reference(TYPE_KEY, messageId);
    }

    @NonNull
    static Reference newReference(@NonNull Message message) {
        return Message.newReference(message.getId());
    }

    @Nullable
    public JSONObject toJson() {
        return this.record.toJson();
    }

    public static Message fromJson(JSONObject jsonObject) throws JSONException {
        Record record = Record.fromJson((JSONObject)jsonObject);
        Message message = new Message(record);
        if (jsonObject.has(ATTACHMENT_KEY)) {
            JSONObject assetJson = jsonObject.getJSONObject(ATTACHMENT_KEY);
            message.setAsset(MessageAssetSerializer.deserialize(assetJson));
        }
        return message;
    }

    public static enum Status {
        DELIVERED("delivered"),
        SOME_READ("some_read"),
        ALL_READ("all_read");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Status(String name) {
            this.name = name;
        }

        @Nullable
        static Status fromName(String name) {
            Status status = null;
            for (Status eachStatus : Status.values()) {
                if (!eachStatus.getName().equals(name)) continue;
                status = eachStatus;
                break;
            }
            return status;
        }
    }
}

