/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.realm.Realm;
import io.skygear.plugins.chat.CacheController;
import io.skygear.plugins.chat.Conversation;
import io.skygear.plugins.chat.ConversationSubscriptionCallback;
import io.skygear.plugins.chat.DateUtils;
import io.skygear.plugins.chat.DeleteCallback;
import io.skygear.plugins.chat.GetCallback;
import io.skygear.plugins.chat.GetMessagesCallback;
import io.skygear.plugins.chat.GetParticipantsCallback;
import io.skygear.plugins.chat.Message;
import io.skygear.plugins.chat.MessageAssetCacheHelper;
import io.skygear.plugins.chat.MessageOperation;
import io.skygear.plugins.chat.MessageOperationCallback;
import io.skygear.plugins.chat.MessageReceipt;
import io.skygear.plugins.chat.MessageSubscriptionCallback;
import io.skygear.plugins.chat.Participant;
import io.skygear.plugins.chat.QueryResponseAdapter;
import io.skygear.plugins.chat.SaveCallback;
import io.skygear.plugins.chat.SaveResponseAdapter;
import io.skygear.plugins.chat.StringUtils;
import io.skygear.plugins.chat.Subscription;
import io.skygear.plugins.chat.Typing;
import io.skygear.plugins.chat.TypingSubscriptionCallback;
import io.skygear.plugins.chat.UserChannelSubscriptionCallback;
import io.skygear.plugins.chat.error.AuthenticationError;
import io.skygear.plugins.chat.error.ConversationAlreadyExistsError;
import io.skygear.plugins.chat.error.ConversationNotFoundError;
import io.skygear.plugins.chat.error.ConversationOperationError;
import io.skygear.plugins.chat.error.InvalidMessageError;
import io.skygear.plugins.chat.error.JSONError;
import io.skygear.plugins.chat.error.MessageOperationError;
import io.skygear.plugins.chat.error.TotalUnreadError;
import io.skygear.skygear.Asset;
import io.skygear.skygear.AssetPostRequest;
import io.skygear.skygear.AuthenticationException;
import io.skygear.skygear.Container;
import io.skygear.skygear.Database;
import io.skygear.skygear.Error;
import io.skygear.skygear.LambdaResponseHandler;
import io.skygear.skygear.PublicDatabase;
import io.skygear.skygear.PubsubContainer;
import io.skygear.skygear.PubsubListener;
import io.skygear.skygear.Query;
import io.skygear.skygear.Record;
import io.skygear.skygear.RecordQueryResponseHandler;
import io.skygear.skygear.RecordSaveResponseHandler;
import io.skygear.skygear.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ChatContainer {
    private static final int GET_MESSAGES_DEFAULT_LIMIT = 50;
    private static final String TAG = "SkygearChatContainer";
    private static ChatContainer sharedInstance;
    private final Container skygear;
    private final CacheController cacheController;
    private final Map<String, Subscription> messageSubscription = new HashMap<String, Subscription>();
    private Subscription conversationSubscription = null;
    private Subscription userChannelSubscription = null;
    private final Map<String, Subscription> typingSubscription = new HashMap<String, Subscription>();

    public static ChatContainer getInstance(@NonNull Container container) {
        if (sharedInstance == null) {
            CacheController cacheController = CacheController.getInstance();
            sharedInstance = new ChatContainer(container, cacheController);
        }
        return sharedInstance;
    }

    private ChatContainer(Container container, CacheController cacheController) {
        if (container == null) {
            throw new NullPointerException("Container can't be null");
        }
        this.skygear = container;
        Realm.init((Context)container.getContext());
        cacheController.cleanUpOnLaunch();
        this.cacheController = cacheController;
    }

    public void createConversation(@NonNull Set<String> participantIds, @Nullable String title, @Nullable Map<String, Object> metadata, @Nullable Map<Conversation.OptionKey, Object> options, final @Nullable SaveCallback<Conversation> callback) {
        this.skygear.callLambdaFunction("chat:create_conversation", new Object[]{new JSONArray(participantIds), title, metadata == null ? null : new JSONObject(metadata), options == null ? null : new JSONObject(this.convertOptionsMap(options))}, new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                block3: {
                    try {
                        Conversation conversation = Conversation.fromJson((JSONObject)result.get("conversation"));
                        if (callback != null) {
                            callback.onSuccess(conversation);
                        }
                    }
                    catch (JSONException e) {
                        if (callback == null) break block3;
                        callback.onFail(new JSONError());
                    }
                }
            }

            public void onLambdaFail(Error error) {
                if (callback != null) {
                    if (ConversationAlreadyExistsError.hasConversationId(error)) {
                        try {
                            callback.onFail(new ConversationAlreadyExistsError(error));
                        }
                        catch (JSONException e) {
                            callback.onFail(new JSONError());
                        }
                    } else {
                        callback.onFail(new ConversationOperationError(error));
                    }
                }
            }
        });
    }

    public void createDirectConversation(@NonNull String participantId, @Nullable String title, @Nullable Map<String, Object> metadata, @Nullable SaveCallback<Conversation> callback) {
        HashSet<String> participantIds = new HashSet<String>();
        participantIds.add(this.skygear.getAuth().getCurrentUser().getId());
        participantIds.add(participantId);
        HashMap<Conversation.OptionKey, Object> options = new HashMap<Conversation.OptionKey, Object>();
        options.put(Conversation.OptionKey.DISTINCT_BY_PARTICIPANTS, true);
        this.createConversation(participantIds, title, metadata, options, callback);
    }

    private Map<String, Object> convertOptionsMap(Map<Conversation.OptionKey, Object> options) {
        HashMap<String, Object> newOptions = new HashMap<String, Object>();
        for (Map.Entry<Conversation.OptionKey, Object> option : options.entrySet()) {
            newOptions.put(option.getKey().getValue(), option.getValue());
        }
        return newOptions;
    }

    public void getConversations(@Nullable GetCallback<List<Conversation>> callback) {
        this.getConversations(callback, true);
    }

    public void getConversation(@NonNull String conversationId, final @Nullable GetCallback<Conversation> callback, boolean getLastMessage) {
        this.getConversation(conversationId, getLastMessage, new GetCallback<Conversation>(){

            @Override
            public void onSuccess(@Nullable Conversation conversation) {
                if (callback != null) {
                    callback.onSuccess(conversation);
                }
            }

            @Override
            public void onFail(@NonNull Error error) {
                if (callback != null) {
                    callback.onFail(error);
                }
            }
        });
    }

    public void getConversation(@NonNull String conversationId, @Nullable GetCallback<Conversation> callback) {
        this.getConversation(conversationId, true, callback);
    }

    public void setConversationTitle(@NonNull Conversation conversation, @NonNull String title, @Nullable SaveCallback<Conversation> callback) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", title);
        this.updateConversation(conversation, map, callback);
    }

    private void updateConversationMembership(@NonNull Conversation conversation, @NonNull String lambda, @NonNull List<String> memberIds, final @Nullable SaveCallback<Conversation> callback) {
        this.skygear.callLambdaFunction(lambda, new Object[]{conversation.getId(), new JSONArray(memberIds)}, new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                block3: {
                    try {
                        Conversation conversation = Conversation.fromJson((JSONObject)result.get("conversation"));
                        if (callback != null) {
                            callback.onSuccess(conversation);
                        }
                    }
                    catch (JSONException e) {
                        if (callback == null) break block3;
                        callback.onFail(new JSONError());
                    }
                }
            }

            public void onLambdaFail(Error error) {
                if (callback != null) {
                    callback.onFail(new ConversationOperationError(error));
                }
            }
        });
    }

    public void addConversationAdmin(@NonNull Conversation conversation, @NonNull String adminId, @Nullable SaveCallback<Conversation> callback) {
        this.addConversationAdmins(conversation, Arrays.asList(adminId), callback);
    }

    public void addConversationAdmins(@NonNull Conversation conversation, @NonNull List<String> adminIds, @Nullable SaveCallback<Conversation> callback) {
        this.updateConversationMembership(conversation, "chat:add_admins", adminIds, callback);
    }

    public void removeConversationAdmins(@NonNull Conversation conversation, @NonNull List<String> adminIds, @Nullable SaveCallback<Conversation> callback) {
        this.updateConversationMembership(conversation, "chat:remove_admins", adminIds, callback);
    }

    public void removeConversationAdmin(@NonNull Conversation conversation, @NonNull String adminId, @Nullable SaveCallback<Conversation> callback) {
        this.removeConversationAdmins(conversation, Arrays.asList(adminId), callback);
    }

    public void addConversationParticipants(@NonNull Conversation conversation, @NonNull List<String> participantIds, @Nullable SaveCallback<Conversation> callback) {
        this.updateConversationMembership(conversation, "chat:add_participants", participantIds, callback);
    }

    public void addConversationParticipant(@NonNull Conversation conversation, @NonNull String participantId, @Nullable SaveCallback<Conversation> callback) {
        this.addConversationParticipants(conversation, Arrays.asList(participantId), callback);
    }

    public void removeConversationParticipants(@NonNull Conversation conversation, @NonNull List<String> participantIds, @Nullable SaveCallback<Conversation> callback) {
        this.updateConversationMembership(conversation, "chat:remove_participants", participantIds, callback);
    }

    public void removeConversationParticipant(@NonNull Conversation conversation, @NonNull String participantId, @Nullable SaveCallback<Conversation> callback) {
        this.removeConversationParticipants(conversation, Arrays.asList(participantId), callback);
    }

    public void setConversationDistinctByParticipants(@NonNull Conversation conversation, @NonNull boolean isDistinctByParticipants, @Nullable SaveCallback<Conversation> callback) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("distinct_by_participant", isDistinctByParticipants);
        this.updateConversation(conversation, map, callback);
    }

    public void setConversationMetadata(@NonNull Conversation conversation, @NonNull Map<String, Object> metadata, @Nullable SaveCallback<Conversation> callback) {
        JSONObject metadataJSON = new JSONObject(metadata);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("metadata", metadataJSON);
        this.updateConversation(conversation, map, callback);
    }

    public void leaveConversation(@NonNull Conversation conversation, @Nullable LambdaResponseHandler callback) {
        this.skygear.callLambdaFunction("chat:leave_conversation", new Object[]{conversation.getId()}, callback);
    }

    public void deleteConversation(@NonNull Conversation conversation, final @Nullable DeleteCallback<Boolean> callback) {
        this.skygear.callLambdaFunction("chat:delete_conversation", new Object[]{conversation.getId()}, new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                callback.onSuccess(true);
            }

            public void onLambdaFail(Error error) {
                if (callback != null) {
                    callback.onFail(new ConversationOperationError(error));
                }
            }
        });
    }

    public void updateConversation(@NonNull Conversation conversation, @NonNull Map<String, Object> updates, final @Nullable SaveCallback<Conversation> callback) {
        PublicDatabase publicDB = this.skygear.getPublicDatabase();
        String conversationId = conversation.getId();
        Record record = new Record(conversation.record.getType(), conversationId);
        for (Map.Entry<String, Object> entry : updates.entrySet()) {
            record.set(entry.getKey(), entry.getValue());
        }
        publicDB.save(record, (RecordSaveResponseHandler)new SaveResponseAdapter<Conversation>(callback){

            @Override
            public Conversation convert(Record record) {
                return new Conversation(record);
            }

            @Override
            public void onSaveFail(Error error) {
                if (callback != null) {
                    callback.onFail(new ConversationOperationError(error));
                }
            }
        });
    }

    public void markConversationLastReadMessage(@NonNull Conversation conversation, @NonNull Message message) {
        this.markMessagesAsRead(Arrays.asList(message));
    }

    public void getTotalUnreadMessageCount(final @Nullable GetCallback<Integer> callback) {
        this.skygear.callLambdaFunction("chat:total_unread", new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                block3: {
                    try {
                        int count = result.getInt("message");
                        if (callback != null) {
                            callback.onSuccess(count);
                        }
                    }
                    catch (JSONException e) {
                        if (callback == null) break block3;
                        callback.onFail(new JSONError());
                    }
                }
            }

            public void onLambdaFail(Error error) {
                if (callback != null) {
                    callback.onFail(new TotalUnreadError(error));
                }
            }
        });
    }

    private void getConversation(final @NonNull String conversationId, @NonNull boolean getLastMessages, final @Nullable GetCallback<Conversation> callback) {
        this.skygear.callLambdaFunction("chat:get_conversation", new Object[]{conversationId, getLastMessages}, new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                block3: {
                    try {
                        Conversation conversation = Conversation.fromJson(result.getJSONObject("conversation"));
                        if (callback != null) {
                            callback.onSuccess(conversation);
                        }
                    }
                    catch (JSONException e) {
                        if (callback == null) break block3;
                        callback.onFail(new JSONError());
                    }
                }
            }

            public void onLambdaFail(Error error) {
                if (callback != null) {
                    callback.onFail(new ConversationNotFoundError(conversationId));
                }
            }
        });
    }

    public void getConversations(final @Nullable GetCallback<List<Conversation>> callback, @NonNull Boolean getLastMessages) {
        this.skygear.callLambdaFunction("chat:get_conversations", new Object[]{1, 50, getLastMessages}, new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                block4: {
                    try {
                        JSONArray items = result.getJSONArray("conversations");
                        ArrayList<Conversation> conversations = new ArrayList<Conversation>();
                        int n = items.length();
                        for (int i = 0; i < n; ++i) {
                            JSONObject o = items.getJSONObject(i);
                            conversations.add(Conversation.fromJson(o));
                        }
                        if (callback != null) {
                            callback.onSuccess(conversations);
                        }
                    }
                    catch (JSONException e) {
                        if (callback == null) break block4;
                        callback.onFail(new JSONError());
                    }
                }
            }

            public void onLambdaFail(Error error) {
                if (callback != null) {
                    callback.onFail(new ConversationOperationError(error));
                }
            }
        });
    }

    public void getMessages(@NonNull Conversation conversation, int limit, @Nullable Message beforeMessage, @Nullable String order, @Nullable GetMessagesCallback callback) {
        this.getMessages(conversation, limit, beforeMessage == null ? null : beforeMessage.getId(), order, callback);
    }

    public void getMessages(@NonNull Conversation conversation, int limit, @Nullable String beforeMessageId, @Nullable String order, @Nullable GetMessagesCallback callback) {
        int limitCount = limit;
        if (limitCount <= 0) {
            limitCount = 50;
        }
        this.cacheController.getMessages(conversation, limitCount, beforeMessageId, order, this.CreateGetCallback(callback));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("conversation_id", conversation.getId());
        args.put("limit", limitCount);
        args.put("before_message_id", beforeMessageId);
        args.put("order", order);
        this.getMessages(args, callback);
    }

    public void getMessages(@NonNull Conversation conversation, int limit, @Nullable Date before, @Nullable String order, @Nullable GetMessagesCallback callback) {
        int limitCount = limit;
        String beforeTimeISO8601 = DateUtils.toISO8601(before != null ? before : new Date());
        if (limitCount <= 0) {
            limitCount = 50;
        }
        this.cacheController.getMessages(conversation, limitCount, before, order, this.CreateGetCallback(callback));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("conversation_id", conversation.getId());
        args.put("limit", limitCount);
        args.put("before_time", beforeTimeISO8601);
        args.put("order", order);
        this.getMessages(args, callback);
    }

    private GetCallback<List<Message>> CreateGetCallback(final @Nullable GetMessagesCallback callback) {
        return new GetCallback<List<Message>>(){

            @Override
            public void onSuccess(@Nullable List<Message> object) {
                if (callback != null) {
                    callback.onGetCachedResult(object);
                }
            }

            @Override
            public void onFail(@NonNull Error error) {
                Log.e((String)ChatContainer.TAG, (String)("Failed to load message from cache: " + error.getMessage()));
            }
        };
    }

    private List<Message> messagesFromJSONArray(JSONArray results) {
        ArrayList<Message> messages = new ArrayList<Message>(results.length());
        if (results != null) {
            for (int i = 0; i < results.length(); ++i) {
                try {
                    JSONObject object = results.getJSONObject(i);
                    Record record = Record.fromJson((JSONObject)object);
                    Message message = new Message(record);
                    messages.add(message);
                    continue;
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)("Fail to get message: " + e.getMessage()));
                }
            }
        }
        return messages;
    }

    private void getMessages(@NonNull HashMap<String, Object> args, final @Nullable GetMessagesCallback callback) {
        this.skygear.callLambdaFunction("chat:get_messages", args, new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                List messages = ChatContainer.this.messagesFromJSONArray(result.optJSONArray("results"));
                if (!messages.isEmpty()) {
                    ChatContainer.this.markMessagesAsDelivered(messages);
                }
                List deletedMessages = ChatContainer.this.messagesFromJSONArray(result.optJSONArray("deleted"));
                Message[] messageArray = new Message[messages.size()];
                Message[] deletedMessagesArray = new Message[deletedMessages.size()];
                ChatContainer.this.cacheController.didGetMessages(messages.toArray(messageArray), deletedMessages.toArray(deletedMessagesArray));
                if (callback != null) {
                    callback.onSuccess(messages);
                }
            }

            public void onLambdaFail(Error error) {
                if (callback != null) {
                    callback.onFail(new MessageOperationError(error));
                }
            }
        });
    }

    public void sendMessage(@NonNull Conversation conversation, @Nullable String body, @Nullable Asset asset, @Nullable JSONObject metadata, @Nullable SaveCallback<Message> callback) {
        if (!StringUtils.isEmpty(body) || asset != null || metadata != null) {
            Record record = new Record("message");
            Message message = new Message(record);
            if (body != null) {
                message.setBody(body);
            }
            if (asset != null) {
                message.setAsset(asset);
            }
            if (metadata != null) {
                message.setMetadata(metadata);
            }
            this.addMessage(message, conversation, callback);
        } else if (callback != null) {
            callback.onFail(new InvalidMessageError());
        }
    }

    public void markMessageAsRead(@NonNull Message message) {
        LinkedList<Message> messages = new LinkedList<Message>();
        messages.add(message);
        this.markMessagesAsRead(messages);
    }

    public void markMessagesAsRead(@NonNull List<Message> messages) {
        JSONArray messageIds = new JSONArray();
        for (Message eachMessage : messages) {
            messageIds.put((Object)eachMessage.getId());
        }
        this.skygear.callLambdaFunction("chat:mark_as_read", new Object[]{messageIds}, new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                Log.i((String)ChatContainer.TAG, (String)"Successfully mark messages as read");
            }

            public void onLambdaFail(Error error) {
                Log.w((String)ChatContainer.TAG, (String)("Fail to mark messages as read: " + error.getMessage()));
            }
        });
    }

    public void markMessageAsDelivered(@NonNull Message message) {
        LinkedList<Message> messages = new LinkedList<Message>();
        messages.add(message);
        this.markMessagesAsDelivered(messages);
    }

    public void markMessagesAsDelivered(@NonNull List<Message> messages) {
        JSONArray messageIds = new JSONArray();
        for (Message eachMessage : messages) {
            messageIds.put((Object)eachMessage.getId());
        }
        this.skygear.callLambdaFunction("chat:mark_as_delivered", new Object[]{messageIds}, new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                Log.i((String)ChatContainer.TAG, (String)"Successfully mark messages as delivered");
            }

            public void onLambdaFail(Error error) {
                Log.w((String)ChatContainer.TAG, (String)("Fail to mark messages as delivered: " + error.getMessage()));
            }
        });
    }

    public void addMessage(@NonNull Message message, @NonNull Conversation conversation, @Nullable SaveCallback<Message> callback) {
        Reference reference = new Reference("conversation", conversation.getId());
        message.record.set("conversation", (Object)reference);
        message.sendDate = new Date();
        if (message.getAsset() == null) {
            this.saveMessage(message, true, callback);
        } else {
            this.saveMessage(message, message.getAsset(), true, callback);
        }
    }

    public void editMessage(@NonNull Message message, @NonNull String body, @Nullable SaveCallback<Message> callback) {
        message.setBody(body);
        this.saveMessage(message, false, callback);
    }

    public void editMessage(@NonNull Message message, @NonNull String body, @Nullable JSONObject metadata, @Nullable Asset asset, @Nullable SaveCallback<Message> callback) {
        message.setBody(body);
        message.setMetadata(metadata);
        message.setAsset(asset);
        this.saveMessage(message, false, callback);
    }

    public void deleteMessage(final @NonNull Message message, final @Nullable DeleteCallback<Message> callback) {
        final MessageOperation operation = this.cacheController.didStartMessageOperation(message, message.getConversationId(), MessageOperation.Type.DELETE);
        this.skygear.callLambdaFunction("chat:delete_message", new Object[]{message.getId()}, new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                if (callback == null) {
                    return;
                }
                ChatContainer.this.cacheController.didDeleteMessage(message);
                ChatContainer.this.cacheController.didCompleteMessageOperation(operation);
                callback.onSuccess(message);
            }

            public void onLambdaFail(Error error) {
                ChatContainer.this.cacheController.didFailMessageOperation(operation, error);
                if (callback != null) {
                    callback.onFail(new MessageOperationError(error));
                }
            }
        });
    }

    private void saveMessage(Message message, Boolean isNewMessage, final @Nullable SaveCallback<Message> callback) {
        final MessageOperation operation = this.cacheController.didStartMessageOperation(message, message.getConversationId(), isNewMessage != false ? MessageOperation.Type.ADD : MessageOperation.Type.EDIT);
        SaveCallback<Message> wrappedCallback = new SaveCallback<Message>(){

            @Override
            public void onSuccess(@Nullable Message savedMessage) {
                if (savedMessage != null) {
                    MessageAssetCacheHelper.deleteMessageAsset(ChatContainer.this.skygear.getContext(), savedMessage.getId());
                    ChatContainer.this.cacheController.didSaveMessage(savedMessage);
                    ChatContainer.this.cacheController.didCompleteMessageOperation(operation);
                }
                if (callback != null) {
                    callback.onSuccess(savedMessage);
                }
            }

            @Override
            public void onFail(@NonNull Error error) {
                ChatContainer.this.cacheController.didFailMessageOperation(operation, error);
                if (callback != null) {
                    callback.onFail(error);
                }
            }
        };
        this.skygear.getPublicDatabase().save(message.getRecord(), (RecordSaveResponseHandler)new SaveResponseAdapter<Message>((SaveCallback)wrappedCallback){

            @Override
            public Message convert(Record record) {
                return new Message(record);
            }
        });
    }

    private void saveMessage(final Message message, Asset asset, final Boolean isNewMessage, final @Nullable SaveCallback<Message> callback) {
        Asset assetFromDisk = MessageAssetCacheHelper.getAsset(this.skygear.getContext(), message.getId());
        if (assetFromDisk != null) {
            asset = assetFromDisk;
        }
        this.skygear.getPublicDatabase().uploadAsset(asset, new AssetPostRequest.ResponseHandler(){

            public void onPostSuccess(Asset asset, String response) {
                message.setAsset(asset);
                MessageAssetCacheHelper.deleteMessageAsset(ChatContainer.this.skygear.getContext(), message.getId());
                ChatContainer.this.saveMessage(message, isNewMessage, callback);
            }

            public void onPostFail(Asset asset, Error error) {
                Log.w((String)ChatContainer.TAG, (String)("Fail to upload asset: " + error.getMessage()));
                MessageAssetCacheHelper.saveMessageAsset(ChatContainer.this.skygear.getContext(), message);
                ChatContainer.this.saveMessage(message, isNewMessage, callback);
            }
        });
    }

    public void fetchOutstandingMessageOperations(@NonNull Conversation conversation, @NonNull MessageOperation.Type operationType, final @Nullable GetCallback<List<MessageOperation>> callback) {
        this.cacheController.fetchMessageOperations(conversation, operationType, new GetCallback<List<MessageOperation>>(){

            @Override
            public void onSuccess(@Nullable List<MessageOperation> operations) {
                if (callback != null) {
                    for (MessageOperation operation : operations) {
                        Asset assetFromDisk;
                        Asset asset = operation.getMessage().getAsset();
                        if (asset == null || (assetFromDisk = MessageAssetCacheHelper.getAsset(ChatContainer.this.skygear.getContext(), operation.message.getId())) == null) continue;
                        operation.getMessage().setAsset(assetFromDisk);
                    }
                    callback.onSuccess(operations);
                }
            }

            @Override
            public void onFail(@NonNull Error error) {
                if (callback != null) {
                    callback.onFail(error);
                }
            }
        });
    }

    public void fetchOutstandingMessageOperations(@NonNull Message message, @NonNull MessageOperation.Type operationType, @Nullable GetCallback<List<MessageOperation>> callback) {
        this.cacheController.fetchMessageOperations(message, operationType, callback);
    }

    public void retryMessageOperation(final @NonNull MessageOperation operation, final @NonNull MessageOperationCallback callback) {
        if (operation.status == MessageOperation.Status.PENDING) {
            Log.w((String)TAG, (String)String.format("Message operation %s is still pending. Pending operations cannot be cancelled.", operation.operationId));
            return;
        }
        this.cacheController.didCancelMessageOperation(operation);
        switch (operation.type) {
            case ADD: 
            case EDIT: {
                SaveCallback<Message> saveCallback = new SaveCallback<Message>(){

                    @Override
                    public void onSuccess(@Nullable Message object) {
                        if (callback != null) {
                            callback.onSuccess(operation, object);
                        }
                    }

                    @Override
                    public void onFail(@NonNull Error error) {
                        if (callback != null) {
                            callback.onFail(error);
                        }
                    }
                };
                if (operation.getMessage().getAsset() != null) {
                    this.saveMessage(operation.getMessage(), operation.getMessage().getAsset(), operation.type == MessageOperation.Type.ADD, saveCallback);
                    break;
                }
                this.saveMessage(operation.getMessage(), operation.type == MessageOperation.Type.ADD, saveCallback);
                break;
            }
            case DELETE: {
                this.deleteMessage(operation.getMessage(), new DeleteCallback<Message>(){

                    @Override
                    public void onSuccess(Message object) {
                        if (callback != null) {
                            callback.onSuccess(operation, object);
                        }
                    }

                    @Override
                    public void onFail(@NonNull Error error) {
                        if (callback != null) {
                            callback.onFail(error);
                        }
                    }
                });
            }
        }
    }

    public void cancelMessageOperation(@NonNull MessageOperation operation) {
        MessageAssetCacheHelper.deleteMessageAsset(this.skygear.getContext(), operation.getMessage().getId());
        if (operation.status == MessageOperation.Status.PENDING) {
            Log.w((String)TAG, (String)String.format("Message operation %s is still pending. Pending operations cannot be cancelled.", operation.operationId));
            return;
        }
        this.cacheController.didCancelMessageOperation(operation);
    }

    public void getMessageReceipt(@NonNull Message message, final @Nullable GetCallback<List<MessageReceipt>> callback) {
        this.skygear.callLambdaFunction("chat:get_receipt", new Object[]{message.getId()}, new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                if (callback == null) {
                    return;
                }
                try {
                    LinkedList<MessageReceipt> receiptList = new LinkedList<MessageReceipt>();
                    JSONArray receipts = result.getJSONArray("receipts");
                    for (int idx = 0; idx < receipts.length(); ++idx) {
                        JSONObject eachReceiptJSON = receipts.getJSONObject(idx);
                        receiptList.add(MessageReceipt.fromJSON(eachReceiptJSON));
                    }
                    callback.onSuccess(receiptList);
                }
                catch (JSONException e) {
                    callback.onFail(new JSONError());
                }
            }

            public void onLambdaFail(Error error) {
                if (callback != null) {
                    callback.onFail(new MessageOperationError(error));
                }
            }
        });
    }

    public void sendTypingIndicator(@NonNull Conversation conversation, @NonNull Typing.State state) {
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime().withZoneUTC();
        String timestamp = dateTimeFormatter.print((ReadableInstant)new DateTime());
        Object[] args = new Object[]{conversation.getId(), state.getName(), timestamp};
        this.skygear.callLambdaFunction("chat:typing", args, new LambdaResponseHandler(){

            public void onLambdaSuccess(JSONObject result) {
                Log.i((String)ChatContainer.TAG, (String)"Successfully send typing indicator");
            }

            public void onLambdaFail(Error error) {
                Log.i((String)ChatContainer.TAG, (String)("Fail to send typing indicator: " + error.getMessage()));
            }
        });
    }

    public void subscribeTypingIndicator(@NonNull Conversation conversation, final @Nullable TypingSubscriptionCallback callback) {
        final PubsubContainer pubsub = this.skygear.getPubsub();
        final String conversationId = conversation.getId();
        if (this.typingSubscription.get(conversationId) == null) {
            this.getOrCreateUserChannel(new GetCallback<Record>(){

                @Override
                public void onSuccess(@Nullable Record userChannelRecord) {
                    if (userChannelRecord != null) {
                        Subscription subscription = new Subscription(conversationId, (String)userChannelRecord.get("name"), callback);
                        subscription.attach(pubsub);
                        ChatContainer.this.typingSubscription.put(conversationId, subscription);
                    }
                }

                @Override
                public void onFail(@NonNull Error error) {
                    Log.w((String)ChatContainer.TAG, (String)("Fail to subscribe typing indicator: " + error.getMessage()));
                    if (callback != null) {
                        callback.onSubscriptionFail(error);
                    }
                }
            });
        }
    }

    public void unsubscribeTypingIndicator(@NonNull Conversation conversation) {
        PubsubContainer pubsub = this.skygear.getPubsub();
        String conversationId = conversation.getId();
        Subscription subscription = this.typingSubscription.get(conversationId);
        if (subscription != null) {
            subscription.detach(pubsub);
            this.typingSubscription.remove(conversationId);
        }
    }

    public void subscribeToConversation(final @Nullable ConversationSubscriptionCallback callback) {
        this.unsubscribeFromConversation();
        this.getOrCreateUserChannel(new GetCallback<Record>(){

            @Override
            public void onSuccess(@Nullable Record userChannelRecord) {
                if (userChannelRecord != null) {
                    Subscription subscription = new Subscription(null, (String)userChannelRecord.get("name"), callback);
                    subscription.attach(ChatContainer.this.skygear.getPubsub());
                    ChatContainer.this.conversationSubscription = subscription;
                }
            }

            @Override
            public void onFail(@NonNull Error error) {
                Log.w((String)ChatContainer.TAG, (String)("Fail to subscribe user channel: " + error.getMessage()));
                if (callback != null) {
                    callback.onSubscriptionFail(error);
                }
            }
        });
    }

    public void unsubscribeFromConversation() {
        if (this.conversationSubscription != null) {
            this.conversationSubscription.detach(this.skygear.getPubsub());
            this.conversationSubscription = null;
        }
    }

    public void subscribeToUserChannel(final @Nullable UserChannelSubscriptionCallback callback) {
        this.unsubscribeFromUserChannel();
        this.getOrCreateUserChannel(new GetCallback<Record>(){

            @Override
            public void onSuccess(@Nullable Record userChannelRecord) {
                if (userChannelRecord != null) {
                    Subscription subscription = new Subscription(null, (String)userChannelRecord.get("name"), callback);
                    subscription.attach(ChatContainer.this.skygear.getPubsub());
                    ChatContainer.this.userChannelSubscription = subscription;
                }
            }

            @Override
            public void onFail(@NonNull Error error) {
                Log.w((String)ChatContainer.TAG, (String)("Fail to subscribe user channel: " + error.getMessage()));
                if (callback != null) {
                    callback.onSubscriptionFail(error);
                }
            }
        });
    }

    public void unsubscribeFromUserChannel() {
        if (this.userChannelSubscription != null) {
            this.userChannelSubscription.detach(this.skygear.getPubsub());
            this.userChannelSubscription = null;
        }
    }

    public void getParticipants(@NonNull Collection<String> participantIds, final @Nullable GetParticipantsCallback callback) {
        Query query = new Query("user");
        query.contains("_id", new ArrayList<String>(participantIds));
        query.setLimit(participantIds.size());
        PublicDatabase publicDB = this.skygear.getPublicDatabase();
        this.cacheController.fetchParticipants(participantIds, this.CreateGetParticipantsCallback(callback));
        GetCallback<List<Participant>> publicDBCallback = new GetCallback<List<Participant>>(){

            @Override
            public void onSuccess(@Nullable List<Participant> participants) {
                HashMap<String, Participant> map = new HashMap<String, Participant>();
                for (Participant user : participants) {
                    map.put(user.getId(), user);
                }
                ChatContainer.this.cacheController.didFetchParticipants(participants);
                callback.onSuccess(map);
            }

            @Override
            public void onFail(@NonNull Error error) {
                callback.onFail(error);
            }
        };
        publicDB.query(query, (RecordQueryResponseHandler)new QueryResponseAdapter<List<Participant>>((GetCallback)publicDBCallback){

            @Override
            public List<Participant> convert(Record[] records) {
                ArrayList<Participant> participants = new ArrayList<Participant>();
                for (Record record : records) {
                    participants.add(new Participant(record));
                }
                return participants;
            }
        });
    }

    private GetCallback<Map<String, Participant>> CreateGetParticipantsCallback(final @Nullable GetParticipantsCallback callback) {
        return new GetCallback<Map<String, Participant>>(){

            @Override
            public void onSuccess(@Nullable Map<String, Participant> object) {
                if (callback != null) {
                    callback.onGetCachedResult(object);
                }
            }

            @Override
            public void onFail(@NonNull Error error) {
                Log.e((String)ChatContainer.TAG, (String)("Failed to load message from cache: " + error.getMessage()));
            }
        };
    }

    public void subscribeConversationMessage(@NonNull Conversation conversation, final @Nullable MessageSubscriptionCallback callback) {
        final PubsubContainer pubsub = this.skygear.getPubsub();
        final String conversationId = conversation.getId();
        if (this.messageSubscription.get(conversationId) == null) {
            final MessageSubscriptionCallback wrappedCallback = new MessageSubscriptionCallback(conversation){

                @Override
                public void notify(@NonNull String eventType, @NonNull Message message) {
                    ChatContainer.this.cacheController.handleMessageChange(message, eventType);
                    if (callback != null) {
                        callback.notify(eventType, message);
                    }
                }

                @Override
                public void onSubscriptionFail(@NonNull Error error) {
                    if (callback != null) {
                        callback.onSubscriptionFail(error);
                    }
                }
            };
            this.getOrCreateUserChannel(new GetCallback<Record>(){

                @Override
                public void onSuccess(@Nullable Record userChannelRecord) {
                    if (userChannelRecord != null) {
                        Subscription subscription = new Subscription(conversationId, (String)userChannelRecord.get("name"), wrappedCallback);
                        subscription.attach(pubsub);
                        ChatContainer.this.messageSubscription.put(conversationId, subscription);
                    }
                }

                @Override
                public void onFail(@NonNull Error error) {
                    Log.w((String)ChatContainer.TAG, (String)("Fail to subscribe conversation message: " + error.getMessage()));
                    wrappedCallback.onSubscriptionFail(error);
                }
            });
        }
    }

    public void unsubscribeConversationMessage(@NonNull Conversation conversation) {
        PubsubContainer pubsub = this.skygear.getPubsub();
        String conversationId = conversation.getId();
        Subscription subscription = this.messageSubscription.get(conversationId);
        if (subscription != null) {
            subscription.detach(pubsub);
            this.messageSubscription.remove(conversationId);
        }
    }

    public void setPubsubListener(@Nullable PubsubListener listener) {
        this.skygear.getPubsub().setListener(listener);
    }

    private void getOrCreateUserChannel(final @Nullable GetCallback<Record> callback) {
        block2: {
            try {
                Query query = new Query("user_channel");
                Database privateDatabase = this.skygear.getPrivateDatabase();
                privateDatabase.query(query, new RecordQueryResponseHandler(){

                    public void onQuerySuccess(Record[] records) {
                        if (records.length != 0) {
                            if (callback != null) {
                                callback.onSuccess(records[0]);
                            }
                        } else {
                            ChatContainer.this.createUserChannel(callback);
                        }
                    }

                    public void onQueryError(Error error) {
                        if (callback != null) {
                            callback.onFail(error);
                        }
                    }
                });
            }
            catch (AuthenticationException e) {
                if (callback == null) break block2;
                callback.onFail(new AuthenticationError(e.getMessage()));
            }
        }
    }

    private void createUserChannel(final GetCallback<Record> callback) {
        try {
            Record conversation = new Record("user_channel");
            conversation.set("name", (Object)UUID.randomUUID().toString());
            RecordSaveResponseHandler handler = new RecordSaveResponseHandler(){

                public void onSaveSuccess(Record[] records) {
                    Record record = records[0];
                    if (callback != null) {
                        callback.onSuccess(record);
                    }
                }

                public void onPartiallySaveSuccess(Map<String, Record> successRecords, Map<String, Error> errors) {
                }

                public void onSaveFail(Error error) {
                    if (callback != null) {
                        callback.onFail(error);
                    }
                }
            };
            Database db = this.skygear.getPrivateDatabase();
            db.save(conversation, handler);
        }
        catch (AuthenticationException e) {
            callback.onFail(new AuthenticationError(e.getMessage()));
        }
    }
}

