/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import io.realm.OrderedCollectionChangeSet;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.OrderedRealmCollectionSnapshot;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.Sort;
import io.realm.annotations.RealmModule;
import io.skygear.plugins.chat.Message;
import io.skygear.plugins.chat.MessageCacheObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class RealmStore {
    private final String name;
    private final boolean inMemory;
    private final boolean async;

    RealmStore(String name, boolean inMemory) {
        this.name = name;
        this.inMemory = inMemory;
        this.async = true;
    }

    RealmStore(String name, boolean inMemory, boolean async) {
        this.name = name;
        this.inMemory = inMemory;
        this.async = async;
    }

    Realm getRealm() {
        RealmConfiguration.Builder configBuilder = new RealmConfiguration.Builder().name(this.name).schemaVersion(1L).modules((Object)new SkygearChatModule(), new Object[0]);
        if (this.inMemory) {
            configBuilder = configBuilder.inMemory();
        }
        return Realm.getInstance((RealmConfiguration)configBuilder.build());
    }

    private void getMessages(RealmResults<MessageCacheObject> results, int limit, ResultCallback<Message[]> callback) {
        OrderedRealmCollectionSnapshot snapshot = results.createSnapshot();
        int resolvedLimit = limit;
        int size = snapshot.size();
        if (limit == -1 || limit > size) {
            resolvedLimit = size;
        }
        ArrayList<Message> messages = new ArrayList<Message>(resolvedLimit);
        ArrayList<MessageCacheObject> faultyCacheObjects = new ArrayList<MessageCacheObject>();
        for (int i = 0; i < resolvedLimit; ++i) {
            MessageCacheObject cacheObject = (MessageCacheObject)snapshot.get(i);
            if (cacheObject == null) {
                throw new RuntimeException("Unexpected null object when getting message query result");
            }
            try {
                Message message = cacheObject.toMessage();
                messages.add(message);
                continue;
            }
            catch (Exception e) {
                faultyCacheObjects.add(cacheObject);
            }
        }
        if (faultyCacheObjects.size() > 0) {
            Realm realm = this.getRealm();
            realm.beginTransaction();
            for (MessageCacheObject cacheObject : faultyCacheObjects) {
                cacheObject.deleteFromRealm();
            }
            realm.commitTransaction();
        }
        Message[] messageArray = new Message[messages.size()];
        callback.onResultGet(messages.toArray(messageArray));
    }

    void getMessages(@Nonnull QueryBuilder<MessageCacheObject> queryBuilder, final int limit, @Nonnull String order, final @Nonnull ResultCallback<Message[]> callback) {
        RealmQuery<MessageCacheObject> query = this.getRealm().where(MessageCacheObject.class);
        query = queryBuilder.buildQueryFrom(query);
        if (this.async) {
            final RealmResults results = query.findAllSortedAsync(order, Sort.DESCENDING);
            results.addChangeListener((OrderedRealmCollectionChangeListener)new OrderedRealmCollectionChangeListener<RealmResults<MessageCacheObject>>(){

                public void onChange(RealmResults<MessageCacheObject> messageCacheObjects, @Nullable OrderedCollectionChangeSet changeSet) {
                    results.removeAllChangeListeners();
                    RealmStore.this.getMessages((RealmResults<MessageCacheObject>)messageCacheObjects, limit, callback);
                }
            });
        } else {
            RealmResults results = query.findAllSorted(order, Sort.DESCENDING);
            this.getMessages((RealmResults<MessageCacheObject>)results, limit, callback);
        }
    }

    void getMessageWithID(@Nonnull String messageID, final @Nonnull ResultCallback<Message> callback) {
        final ResultCallback<Message[]> wrappedCallback = new ResultCallback<Message[]>(){

            @Override
            public void onResultGet(Message[] result) {
                if (result.length == 0) {
                    callback.onResultGet(null);
                } else {
                    callback.onResultGet(result[0]);
                }
            }
        };
        if (this.async) {
            final RealmResults results = this.getRealm().where(MessageCacheObject.class).equalTo(MessageCacheObject.KEY_RECORD_ID, messageID).findAllAsync();
            results.addChangeListener((OrderedRealmCollectionChangeListener)new OrderedRealmCollectionChangeListener<RealmResults<MessageCacheObject>>(){

                public void onChange(RealmResults<MessageCacheObject> messageCacheObjects, @Nullable OrderedCollectionChangeSet changeSet) {
                    results.removeAllChangeListeners();
                    RealmStore.this.getMessages((RealmResults<MessageCacheObject>)messageCacheObjects, 1, wrappedCallback);
                }
            });
        } else {
            RealmResults results = this.getRealm().where(MessageCacheObject.class).equalTo(MessageCacheObject.KEY_RECORD_ID, messageID).findAll();
            this.getMessages((RealmResults<MessageCacheObject>)results, 1, wrappedCallback);
        }
    }

    private void setMessages(Realm realm, Message[] messages) {
        ArrayList<MessageCacheObject> cacheObjects = new ArrayList<MessageCacheObject>(messages.length);
        for (Message message : messages) {
            MessageCacheObject cacheObject = new MessageCacheObject(message);
            cacheObjects.add(cacheObject);
        }
        realm.insertOrUpdate(cacheObjects);
    }

    void setMessages(final Message[] messages) {
        Realm.Transaction transaction = new Realm.Transaction(){

            public void execute(Realm realm) {
                RealmStore.this.setMessages(realm, messages);
            }
        };
        if (this.async) {
            this.getRealm().executeTransactionAsync(transaction);
        } else {
            this.getRealm().executeTransaction(transaction);
        }
    }

    private void deleteMessages(Realm realm, Message[] messages) {
        String[] messageIDs = new String[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            messageIDs[i] = messages[i].getId();
        }
        RealmResults cacheObjects = realm.where(MessageCacheObject.class).in(MessageCacheObject.KEY_RECORD_ID, messageIDs).findAll();
        cacheObjects.deleteAllFromRealm();
    }

    void deleteMessages(final Message[] messages) {
        Realm.Transaction transaction = new Realm.Transaction(){

            public void execute(Realm realm) {
                RealmStore.this.deleteMessages(realm, messages);
            }
        };
        if (this.async) {
            this.getRealm().executeTransactionAsync(transaction);
        } else {
            this.getRealm().executeTransaction(transaction);
        }
    }

    void deleteAll() {
        Realm.Transaction transaction = new Realm.Transaction(){

            public void execute(Realm realm) {
                realm.deleteAll();
            }
        };
        if (this.async) {
            this.getRealm().executeTransactionAsync(transaction);
        } else {
            this.getRealm().executeTransaction(transaction);
        }
    }

    @RealmModule(library=true, classes={MessageCacheObject.class})
    private static class SkygearChatModule {
        private SkygearChatModule() {
        }
    }

    static interface ResultCallback<T> {
        public void onResultGet(T var1);
    }

    static interface QueryBuilder<T> {
        public RealmQuery<T> buildQueryFrom(RealmQuery<T> var1);
    }
}

