/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.skygear.plugins.chat.Message;
import io.skygear.skygear.Record;
import io.skygear.skygear.Reference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Conversation {
    static final String TYPE_KEY = "conversation";
    static final String TITLE_KEY = "title";
    static final String LAST_MESSAGE_KEY = "last_message";
    static final String LAST_READ_MESSAGE_KEY = "last_read_message";
    static final String LAST_MESSAGE_REF_KEY = "last_message_ref";
    static final String LAST_READ_MESSAGE_REF_KEY = "last_read_message_ref";
    static final String ADMIN_IDS_KEY = "admin_ids";
    static final String PARTICIPANT_IDS_KEY = "participant_ids";
    static final String DISTINCT_BY_PARTICIPANTS_KEY = "distinct_by_participant";
    static final String METADATA_KEY = "metadata";
    static final String UNREAD_COUNT = "unread_count";
    final Record record;
    private Set<String> adminIds;
    private Set<String> participantIds;
    private Message lastMessage;
    private Message lastReadMessage;
    private static final String TAG = "SkygearChatConversation";

    Conversation(Record record) {
        JSONArray participantIds;
        this.record = record;
        JSONArray adminIds = (JSONArray)record.get(ADMIN_IDS_KEY);
        if (adminIds != null) {
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < adminIds.length(); ++i) {
                String id = adminIds.optString(i);
                if (id == null) continue;
                ids.add(id);
            }
            this.adminIds = ids;
        }
        if ((participantIds = (JSONArray)record.get(PARTICIPANT_IDS_KEY)) != null) {
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < participantIds.length(); ++i) {
                String id = participantIds.optString(i);
                if (id == null) continue;
                ids.add(id);
            }
            this.participantIds = ids;
        }
    }

    @NonNull
    public String getId() {
        return this.record.getId();
    }

    @Nullable
    public String getTitle() {
        return (String)this.record.get(TITLE_KEY);
    }

    @Nullable
    public String getLastMessageId() {
        Object obj = this.record.get(LAST_MESSAGE_REF_KEY);
        if (!JSONObject.NULL.equals(obj)) {
            Reference ref = (Reference)obj;
            return ref.getId();
        }
        return null;
    }

    @Nullable
    public String getLastReadMessageId() {
        Object obj = this.record.get(LAST_READ_MESSAGE_REF_KEY);
        if (!JSONObject.NULL.equals(obj)) {
            Reference ref = (Reference)obj;
            return ref.getId();
        }
        return null;
    }

    @Nullable
    private Message getMessage(String key) {
        JSONObject messageRecord;
        Object obj = this.record.get(key);
        if (!JSONObject.NULL.equals(obj) && (messageRecord = (JSONObject)obj) != null) {
            try {
                return Message.fromJson(messageRecord);
            }
            catch (JSONException e) {
                Log.w((String)TAG, (String)"Fail parsing last_message", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public Message getLastMessage() {
        if (this.lastMessage == null) {
            this.lastMessage = this.getMessage(LAST_MESSAGE_KEY);
        }
        return this.lastMessage;
    }

    @Nullable
    public Message getLastReadMessage() {
        if (this.lastReadMessage == null) {
            this.lastReadMessage = this.getMessage(LAST_READ_MESSAGE_KEY);
        }
        return this.lastReadMessage;
    }

    public int getUnreadCount() {
        return (Integer)this.record.get(UNREAD_COUNT);
    }

    @Nullable
    public Set<String> getAdminIds() {
        return this.adminIds;
    }

    @Nullable
    public Set<String> getParticipantIds() {
        return this.participantIds;
    }

    public Map<String, Object> getMetadata() {
        Object metadata = this.record.get(METADATA_KEY);
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof JSONObject) {
            JSONObject metadataObject = (JSONObject)metadata;
            Iterator keys = metadataObject.keys();
            HashMap<String, Object> metadataMap = new HashMap<String, Object>();
            while (keys.hasNext()) {
                String eachKey = (String)keys.next();
                try {
                    Object eachValue = metadataObject.get(eachKey);
                    metadataMap.put(eachKey, eachValue);
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException(String.format("Missing value for key %s", eachKey));
                }
            }
            return metadataMap;
        }
        throw new IllegalArgumentException("Metadata is in incorrect format");
    }

    public boolean isDistinctByParticipants() {
        return (Boolean)this.record.get(DISTINCT_BY_PARTICIPANTS_KEY);
    }

    public Record getRecord() {
        return this.record;
    }

    @Nullable
    public JSONObject toJson() {
        return this.record.toJson();
    }

    public static Conversation fromJson(JSONObject jsonObject) throws JSONException {
        return new Conversation(Record.fromJson((JSONObject)jsonObject));
    }

    public static enum OptionKey {
        ADMIN_IDS("admin_ids"),
        DISTINCT_BY_PARTICIPANTS("distinctByParticipants");

        private final String value;

        private OptionKey(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }
    }
}

