/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.TargetApi;
import android.util.JsonReader;
import android.util.JsonToken;
import io.realm.BaseRealm;
import io.realm.MessageCacheObjectRealmProxyInterface;
import io.realm.ProxyState;
import io.realm.Realm;
import io.realm.RealmFieldType;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.exceptions.RealmException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.OsObject;
import io.realm.internal.OsObjectSchemaInfo;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.android.JsonUtils;
import io.skygear.plugins.chat.MessageCacheObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageCacheObjectRealmProxy
extends MessageCacheObject
implements RealmObjectProxy,
MessageCacheObjectRealmProxyInterface {
    private static final OsObjectSchemaInfo expectedObjectSchemaInfo = MessageCacheObjectRealmProxy.createExpectedObjectSchemaInfo();
    private static final List<String> FIELD_NAMES;
    private MessageCacheObjectColumnInfo columnInfo;
    private ProxyState<MessageCacheObject> proxyState;

    MessageCacheObjectRealmProxy() {
        this.proxyState.setConstructionFinished();
    }

    public void realm$injectObjectContext() {
        if (this.proxyState != null) {
            return;
        }
        BaseRealm.RealmObjectContext context = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
        this.columnInfo = (MessageCacheObjectColumnInfo)context.getColumnInfo();
        this.proxyState = new ProxyState((RealmModel)this);
        this.proxyState.setRealm$realm(context.getRealm());
        this.proxyState.setRow$realm(context.getRow());
        this.proxyState.setAcceptDefaultValue$realm(context.getAcceptDefaultValue());
        this.proxyState.setExcludeFields$realm(context.getExcludeFields());
    }

    @Override
    public String realmGet$recordID() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.recordIDIndex);
    }

    @Override
    public void realmSet$recordID(String value) {
        if (this.proxyState.isUnderConstruction()) {
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        throw new RealmException("Primary key field 'recordID' cannot be changed after object was created.");
    }

    @Override
    public String realmGet$conversationID() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.conversationIDIndex);
    }

    @Override
    public void realmSet$conversationID(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.conversationIDIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.conversationIDIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.conversationIDIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.conversationIDIndex, value);
    }

    @Override
    public Date realmGet$creationDate() {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this.proxyState.getRow$realm().isNull(this.columnInfo.creationDateIndex)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(this.columnInfo.creationDateIndex);
    }

    @Override
    public void realmSet$creationDate(Date value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.creationDateIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setDate(this.columnInfo.creationDateIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.creationDateIndex);
            return;
        }
        this.proxyState.getRow$realm().setDate(this.columnInfo.creationDateIndex, value);
    }

    @Override
    public Date realmGet$editionDate() {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this.proxyState.getRow$realm().isNull(this.columnInfo.editionDateIndex)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(this.columnInfo.editionDateIndex);
    }

    @Override
    public void realmSet$editionDate(Date value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.editionDateIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setDate(this.columnInfo.editionDateIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.editionDateIndex);
            return;
        }
        this.proxyState.getRow$realm().setDate(this.columnInfo.editionDateIndex, value);
    }

    @Override
    public Date realmGet$sendDate() {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this.proxyState.getRow$realm().isNull(this.columnInfo.sendDateIndex)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(this.columnInfo.sendDateIndex);
    }

    @Override
    public void realmSet$sendDate(Date value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.sendDateIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setDate(this.columnInfo.sendDateIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.sendDateIndex);
            return;
        }
        this.proxyState.getRow$realm().setDate(this.columnInfo.sendDateIndex, value);
    }

    @Override
    public boolean realmGet$deleted() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getBoolean(this.columnInfo.deletedIndex);
    }

    @Override
    public void realmSet$deleted(boolean value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            row.getTable().setBoolean(this.columnInfo.deletedIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        this.proxyState.getRow$realm().setBoolean(this.columnInfo.deletedIndex, value);
    }

    @Override
    public boolean realmGet$alreadySyncToServer() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getBoolean(this.columnInfo.alreadySyncToServerIndex);
    }

    @Override
    public void realmSet$alreadySyncToServer(boolean value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            row.getTable().setBoolean(this.columnInfo.alreadySyncToServerIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        this.proxyState.getRow$realm().setBoolean(this.columnInfo.alreadySyncToServerIndex, value);
    }

    @Override
    public boolean realmGet$fail() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getBoolean(this.columnInfo.failIndex);
    }

    @Override
    public void realmSet$fail(boolean value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            row.getTable().setBoolean(this.columnInfo.failIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        this.proxyState.getRow$realm().setBoolean(this.columnInfo.failIndex, value);
    }

    @Override
    public String realmGet$jsonData() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.jsonDataIndex);
    }

    @Override
    public void realmSet$jsonData(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.jsonDataIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.jsonDataIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.jsonDataIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.jsonDataIndex, value);
    }

    private static OsObjectSchemaInfo createExpectedObjectSchemaInfo() {
        OsObjectSchemaInfo.Builder builder = new OsObjectSchemaInfo.Builder("MessageCacheObject", 9, 0);
        builder.addPersistedProperty("recordID", RealmFieldType.STRING, true, true, false);
        builder.addPersistedProperty("conversationID", RealmFieldType.STRING, false, false, false);
        builder.addPersistedProperty("creationDate", RealmFieldType.DATE, false, false, false);
        builder.addPersistedProperty("editionDate", RealmFieldType.DATE, false, false, false);
        builder.addPersistedProperty("sendDate", RealmFieldType.DATE, false, false, false);
        builder.addPersistedProperty("deleted", RealmFieldType.BOOLEAN, false, false, true);
        builder.addPersistedProperty("alreadySyncToServer", RealmFieldType.BOOLEAN, false, false, true);
        builder.addPersistedProperty("fail", RealmFieldType.BOOLEAN, false, false, true);
        builder.addPersistedProperty("jsonData", RealmFieldType.STRING, false, false, false);
        return builder.build();
    }

    public static OsObjectSchemaInfo getExpectedObjectSchemaInfo() {
        return expectedObjectSchemaInfo;
    }

    public static MessageCacheObjectColumnInfo createColumnInfo(OsSchemaInfo schemaInfo) {
        return new MessageCacheObjectColumnInfo(schemaInfo);
    }

    public static String getSimpleClassName() {
        return "MessageCacheObject";
    }

    public static List<String> getFieldNames() {
        return FIELD_NAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageCacheObject createOrUpdateUsingJsonObject(Realm realm, JSONObject json, boolean update) throws JSONException {
        Object timestamp;
        List excludeFields = Collections.emptyList();
        MessageCacheObjectRealmProxy obj = null;
        if (update) {
            Table table = realm.getTable(MessageCacheObject.class);
            MessageCacheObjectColumnInfo columnInfo = (MessageCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageCacheObject.class);
            long pkColumnIndex = columnInfo.recordIDIndex;
            long rowIndex = -1L;
            rowIndex = json.isNull("recordID") ? table.findFirstNull(pkColumnIndex) : table.findFirstString(pkColumnIndex, json.getString("recordID"));
            if (rowIndex != -1L) {
                BaseRealm.RealmObjectContext objectContext = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
                try {
                    objectContext.set((BaseRealm)realm, (Row)table.getUncheckedRow(rowIndex), realm.getSchema().getColumnInfo(MessageCacheObject.class), false, Collections.emptyList());
                    obj = new MessageCacheObjectRealmProxy();
                }
                finally {
                    objectContext.clear();
                }
            }
        }
        if (obj == null) {
            if (json.has("recordID")) {
                obj = json.isNull("recordID") ? (MessageCacheObjectRealmProxy)realm.createObjectInternal(MessageCacheObject.class, null, true, excludeFields) : (MessageCacheObjectRealmProxy)realm.createObjectInternal(MessageCacheObject.class, (Object)json.getString("recordID"), true, excludeFields);
            } else {
                throw new IllegalArgumentException("JSON object doesn't have the primary key field 'recordID'.");
            }
        }
        MessageCacheObjectRealmProxyInterface objProxy = obj;
        if (json.has("conversationID")) {
            if (json.isNull("conversationID")) {
                objProxy.realmSet$conversationID(null);
            } else {
                objProxy.realmSet$conversationID(json.getString("conversationID"));
            }
        }
        if (json.has("creationDate")) {
            if (json.isNull("creationDate")) {
                objProxy.realmSet$creationDate(null);
            } else {
                timestamp = json.get("creationDate");
                if (timestamp instanceof String) {
                    objProxy.realmSet$creationDate(JsonUtils.stringToDate((String)((String)timestamp)));
                } else {
                    objProxy.realmSet$creationDate(new Date(json.getLong("creationDate")));
                }
            }
        }
        if (json.has("editionDate")) {
            if (json.isNull("editionDate")) {
                objProxy.realmSet$editionDate(null);
            } else {
                timestamp = json.get("editionDate");
                if (timestamp instanceof String) {
                    objProxy.realmSet$editionDate(JsonUtils.stringToDate((String)((String)timestamp)));
                } else {
                    objProxy.realmSet$editionDate(new Date(json.getLong("editionDate")));
                }
            }
        }
        if (json.has("sendDate")) {
            if (json.isNull("sendDate")) {
                objProxy.realmSet$sendDate(null);
            } else {
                timestamp = json.get("sendDate");
                if (timestamp instanceof String) {
                    objProxy.realmSet$sendDate(JsonUtils.stringToDate((String)((String)timestamp)));
                } else {
                    objProxy.realmSet$sendDate(new Date(json.getLong("sendDate")));
                }
            }
        }
        if (json.has("deleted")) {
            if (json.isNull("deleted")) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'deleted' to null.");
            }
            objProxy.realmSet$deleted(json.getBoolean("deleted"));
        }
        if (json.has("alreadySyncToServer")) {
            if (json.isNull("alreadySyncToServer")) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'alreadySyncToServer' to null.");
            }
            objProxy.realmSet$alreadySyncToServer(json.getBoolean("alreadySyncToServer"));
        }
        if (json.has("fail")) {
            if (json.isNull("fail")) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'fail' to null.");
            }
            objProxy.realmSet$fail(json.getBoolean("fail"));
        }
        if (json.has("jsonData")) {
            if (json.isNull("jsonData")) {
                objProxy.realmSet$jsonData(null);
            } else {
                objProxy.realmSet$jsonData(json.getString("jsonData"));
            }
        }
        return obj;
    }

    @TargetApi(value=11)
    public static MessageCacheObject createUsingJsonStream(Realm realm, JsonReader reader) throws IOException {
        boolean jsonHasPrimaryKey = false;
        MessageCacheObject obj = new MessageCacheObject();
        MessageCacheObjectRealmProxyInterface objProxy = obj;
        reader.beginObject();
        while (reader.hasNext()) {
            long timestamp;
            String name = reader.nextName();
            if (name.equals("recordID")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$recordID(reader.nextString());
                } else {
                    reader.skipValue();
                    objProxy.realmSet$recordID(null);
                }
                jsonHasPrimaryKey = true;
                continue;
            }
            if (name.equals("conversationID")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$conversationID(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$conversationID(null);
                continue;
            }
            if (name.equals("creationDate")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    objProxy.realmSet$creationDate(null);
                    continue;
                }
                if (reader.peek() == JsonToken.NUMBER) {
                    timestamp = reader.nextLong();
                    if (timestamp <= -1L) continue;
                    objProxy.realmSet$creationDate(new Date(timestamp));
                    continue;
                }
                objProxy.realmSet$creationDate(JsonUtils.stringToDate((String)reader.nextString()));
                continue;
            }
            if (name.equals("editionDate")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    objProxy.realmSet$editionDate(null);
                    continue;
                }
                if (reader.peek() == JsonToken.NUMBER) {
                    timestamp = reader.nextLong();
                    if (timestamp <= -1L) continue;
                    objProxy.realmSet$editionDate(new Date(timestamp));
                    continue;
                }
                objProxy.realmSet$editionDate(JsonUtils.stringToDate((String)reader.nextString()));
                continue;
            }
            if (name.equals("sendDate")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    objProxy.realmSet$sendDate(null);
                    continue;
                }
                if (reader.peek() == JsonToken.NUMBER) {
                    timestamp = reader.nextLong();
                    if (timestamp <= -1L) continue;
                    objProxy.realmSet$sendDate(new Date(timestamp));
                    continue;
                }
                objProxy.realmSet$sendDate(JsonUtils.stringToDate((String)reader.nextString()));
                continue;
            }
            if (name.equals("deleted")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$deleted(reader.nextBoolean());
                    continue;
                }
                reader.skipValue();
                throw new IllegalArgumentException("Trying to set non-nullable field 'deleted' to null.");
            }
            if (name.equals("alreadySyncToServer")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$alreadySyncToServer(reader.nextBoolean());
                    continue;
                }
                reader.skipValue();
                throw new IllegalArgumentException("Trying to set non-nullable field 'alreadySyncToServer' to null.");
            }
            if (name.equals("fail")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$fail(reader.nextBoolean());
                    continue;
                }
                reader.skipValue();
                throw new IllegalArgumentException("Trying to set non-nullable field 'fail' to null.");
            }
            if (name.equals("jsonData")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$jsonData(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$jsonData(null);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (!jsonHasPrimaryKey) {
            throw new IllegalArgumentException("JSON object doesn't have the primary key field 'recordID'.");
        }
        return (MessageCacheObject)realm.copyToRealm((RealmModel)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageCacheObject copyOrUpdate(Realm realm, MessageCacheObject object, boolean update, Map<RealmModel, RealmObjectProxy> cache) {
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null) {
            BaseRealm otherRealm = ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm();
            if (otherRealm.threadId != realm.threadId) {
                throw new IllegalArgumentException("Objects which belong to Realm instances in other threads cannot be copied into this Realm instance.");
            }
            if (otherRealm.getPath().equals(realm.getPath())) {
                return object;
            }
        }
        BaseRealm.RealmObjectContext objectContext = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
        RealmObjectProxy cachedRealmObject = cache.get(object);
        if (cachedRealmObject != null) {
            return (MessageCacheObject)cachedRealmObject;
        }
        MessageCacheObjectRealmProxy realmObject = null;
        boolean canUpdate = update;
        if (canUpdate) {
            Table table = realm.getTable(MessageCacheObject.class);
            MessageCacheObjectColumnInfo columnInfo = (MessageCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageCacheObject.class);
            long pkColumnIndex = columnInfo.recordIDIndex;
            String value = ((MessageCacheObjectRealmProxyInterface)object).realmGet$recordID();
            long rowIndex = -1L;
            rowIndex = value == null ? table.findFirstNull(pkColumnIndex) : table.findFirstString(pkColumnIndex, value);
            if (rowIndex == -1L) {
                canUpdate = false;
            } else {
                try {
                    objectContext.set((BaseRealm)realm, (Row)table.getUncheckedRow(rowIndex), realm.getSchema().getColumnInfo(MessageCacheObject.class), false, Collections.emptyList());
                    realmObject = new MessageCacheObjectRealmProxy();
                    cache.put((RealmModel)object, realmObject);
                }
                finally {
                    objectContext.clear();
                }
            }
        }
        return canUpdate ? MessageCacheObjectRealmProxy.update(realm, realmObject, object, cache) : MessageCacheObjectRealmProxy.copy(realm, object, update, cache);
    }

    public static MessageCacheObject copy(Realm realm, MessageCacheObject newObject, boolean update, Map<RealmModel, RealmObjectProxy> cache) {
        RealmObjectProxy cachedRealmObject = cache.get(newObject);
        if (cachedRealmObject != null) {
            return (MessageCacheObject)cachedRealmObject;
        }
        MessageCacheObject realmObject = (MessageCacheObject)realm.createObjectInternal(MessageCacheObject.class, (Object)((MessageCacheObjectRealmProxyInterface)newObject).realmGet$recordID(), false, Collections.emptyList());
        cache.put((RealmModel)newObject, (RealmObjectProxy)realmObject);
        MessageCacheObjectRealmProxyInterface realmObjectSource = newObject;
        MessageCacheObjectRealmProxyInterface realmObjectCopy = realmObject;
        realmObjectCopy.realmSet$conversationID(realmObjectSource.realmGet$conversationID());
        realmObjectCopy.realmSet$creationDate(realmObjectSource.realmGet$creationDate());
        realmObjectCopy.realmSet$editionDate(realmObjectSource.realmGet$editionDate());
        realmObjectCopy.realmSet$sendDate(realmObjectSource.realmGet$sendDate());
        realmObjectCopy.realmSet$deleted(realmObjectSource.realmGet$deleted());
        realmObjectCopy.realmSet$alreadySyncToServer(realmObjectSource.realmGet$alreadySyncToServer());
        realmObjectCopy.realmSet$fail(realmObjectSource.realmGet$fail());
        realmObjectCopy.realmSet$jsonData(realmObjectSource.realmGet$jsonData());
        return realmObject;
    }

    public static long insert(Realm realm, MessageCacheObject object, Map<RealmModel, Long> cache) {
        Date realmGet$sendDate;
        Date realmGet$editionDate;
        Date realmGet$creationDate;
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
            return ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex();
        }
        Table table = realm.getTable(MessageCacheObject.class);
        long tableNativePtr = table.getNativePtr();
        MessageCacheObjectColumnInfo columnInfo = (MessageCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageCacheObject.class);
        long pkColumnIndex = columnInfo.recordIDIndex;
        String primaryKeyValue = ((MessageCacheObjectRealmProxyInterface)object).realmGet$recordID();
        long rowIndex = -1L;
        rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
        if (rowIndex == -1L) {
            rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
        } else {
            Table.throwDuplicatePrimaryKeyException((Object)primaryKeyValue);
        }
        cache.put((RealmModel)object, rowIndex);
        String realmGet$conversationID = ((MessageCacheObjectRealmProxyInterface)object).realmGet$conversationID();
        if (realmGet$conversationID != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (String)realmGet$conversationID, (boolean)false);
        }
        if ((realmGet$creationDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$creationDate()) != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.creationDateIndex, (long)rowIndex, (long)realmGet$creationDate.getTime(), (boolean)false);
        }
        if ((realmGet$editionDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$editionDate()) != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.editionDateIndex, (long)rowIndex, (long)realmGet$editionDate.getTime(), (boolean)false);
        }
        if ((realmGet$sendDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$sendDate()) != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (long)realmGet$sendDate.getTime(), (boolean)false);
        }
        Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.deletedIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$deleted(), (boolean)false);
        Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.alreadySyncToServerIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$alreadySyncToServer(), (boolean)false);
        Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.failIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$fail(), (boolean)false);
        String realmGet$jsonData = ((MessageCacheObjectRealmProxyInterface)object).realmGet$jsonData();
        if (realmGet$jsonData != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (String)realmGet$jsonData, (boolean)false);
        }
        return rowIndex;
    }

    public static void insert(Realm realm, Iterator<? extends RealmModel> objects, Map<RealmModel, Long> cache) {
        Table table = realm.getTable(MessageCacheObject.class);
        long tableNativePtr = table.getNativePtr();
        MessageCacheObjectColumnInfo columnInfo = (MessageCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageCacheObject.class);
        long pkColumnIndex = columnInfo.recordIDIndex;
        MessageCacheObject object = null;
        while (objects.hasNext()) {
            Date realmGet$sendDate;
            Date realmGet$editionDate;
            Date realmGet$creationDate;
            object = (MessageCacheObject)objects.next();
            if (cache.containsKey(object)) continue;
            if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
                cache.put((RealmModel)object, ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex());
                continue;
            }
            String primaryKeyValue = ((MessageCacheObjectRealmProxyInterface)object).realmGet$recordID();
            long rowIndex = -1L;
            rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
            if (rowIndex == -1L) {
                rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
            } else {
                Table.throwDuplicatePrimaryKeyException((Object)primaryKeyValue);
            }
            cache.put((RealmModel)object, rowIndex);
            String realmGet$conversationID = ((MessageCacheObjectRealmProxyInterface)object).realmGet$conversationID();
            if (realmGet$conversationID != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (String)realmGet$conversationID, (boolean)false);
            }
            if ((realmGet$creationDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$creationDate()) != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.creationDateIndex, (long)rowIndex, (long)realmGet$creationDate.getTime(), (boolean)false);
            }
            if ((realmGet$editionDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$editionDate()) != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.editionDateIndex, (long)rowIndex, (long)realmGet$editionDate.getTime(), (boolean)false);
            }
            if ((realmGet$sendDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$sendDate()) != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (long)realmGet$sendDate.getTime(), (boolean)false);
            }
            Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.deletedIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$deleted(), (boolean)false);
            Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.alreadySyncToServerIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$alreadySyncToServer(), (boolean)false);
            Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.failIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$fail(), (boolean)false);
            String realmGet$jsonData = ((MessageCacheObjectRealmProxyInterface)object).realmGet$jsonData();
            if (realmGet$jsonData == null) continue;
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (String)realmGet$jsonData, (boolean)false);
        }
    }

    public static long insertOrUpdate(Realm realm, MessageCacheObject object, Map<RealmModel, Long> cache) {
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
            return ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex();
        }
        Table table = realm.getTable(MessageCacheObject.class);
        long tableNativePtr = table.getNativePtr();
        MessageCacheObjectColumnInfo columnInfo = (MessageCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageCacheObject.class);
        long pkColumnIndex = columnInfo.recordIDIndex;
        String primaryKeyValue = ((MessageCacheObjectRealmProxyInterface)object).realmGet$recordID();
        long rowIndex = -1L;
        rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
        if (rowIndex == -1L) {
            rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
        }
        cache.put((RealmModel)object, rowIndex);
        String realmGet$conversationID = ((MessageCacheObjectRealmProxyInterface)object).realmGet$conversationID();
        if (realmGet$conversationID != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (String)realmGet$conversationID, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (boolean)false);
        }
        Date realmGet$creationDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$creationDate();
        if (realmGet$creationDate != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.creationDateIndex, (long)rowIndex, (long)realmGet$creationDate.getTime(), (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.creationDateIndex, (long)rowIndex, (boolean)false);
        }
        Date realmGet$editionDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$editionDate();
        if (realmGet$editionDate != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.editionDateIndex, (long)rowIndex, (long)realmGet$editionDate.getTime(), (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.editionDateIndex, (long)rowIndex, (boolean)false);
        }
        Date realmGet$sendDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$sendDate();
        if (realmGet$sendDate != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (long)realmGet$sendDate.getTime(), (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (boolean)false);
        }
        Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.deletedIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$deleted(), (boolean)false);
        Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.alreadySyncToServerIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$alreadySyncToServer(), (boolean)false);
        Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.failIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$fail(), (boolean)false);
        String realmGet$jsonData = ((MessageCacheObjectRealmProxyInterface)object).realmGet$jsonData();
        if (realmGet$jsonData != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (String)realmGet$jsonData, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (boolean)false);
        }
        return rowIndex;
    }

    public static void insertOrUpdate(Realm realm, Iterator<? extends RealmModel> objects, Map<RealmModel, Long> cache) {
        Table table = realm.getTable(MessageCacheObject.class);
        long tableNativePtr = table.getNativePtr();
        MessageCacheObjectColumnInfo columnInfo = (MessageCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageCacheObject.class);
        long pkColumnIndex = columnInfo.recordIDIndex;
        MessageCacheObject object = null;
        while (objects.hasNext()) {
            object = (MessageCacheObject)objects.next();
            if (cache.containsKey(object)) continue;
            if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
                cache.put((RealmModel)object, ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex());
                continue;
            }
            String primaryKeyValue = ((MessageCacheObjectRealmProxyInterface)object).realmGet$recordID();
            long rowIndex = -1L;
            rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
            if (rowIndex == -1L) {
                rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
            }
            cache.put((RealmModel)object, rowIndex);
            String realmGet$conversationID = ((MessageCacheObjectRealmProxyInterface)object).realmGet$conversationID();
            if (realmGet$conversationID != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (String)realmGet$conversationID, (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (boolean)false);
            }
            Date realmGet$creationDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$creationDate();
            if (realmGet$creationDate != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.creationDateIndex, (long)rowIndex, (long)realmGet$creationDate.getTime(), (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.creationDateIndex, (long)rowIndex, (boolean)false);
            }
            Date realmGet$editionDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$editionDate();
            if (realmGet$editionDate != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.editionDateIndex, (long)rowIndex, (long)realmGet$editionDate.getTime(), (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.editionDateIndex, (long)rowIndex, (boolean)false);
            }
            Date realmGet$sendDate = ((MessageCacheObjectRealmProxyInterface)object).realmGet$sendDate();
            if (realmGet$sendDate != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (long)realmGet$sendDate.getTime(), (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (boolean)false);
            }
            Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.deletedIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$deleted(), (boolean)false);
            Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.alreadySyncToServerIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$alreadySyncToServer(), (boolean)false);
            Table.nativeSetBoolean((long)tableNativePtr, (long)columnInfo.failIndex, (long)rowIndex, (boolean)((MessageCacheObjectRealmProxyInterface)object).realmGet$fail(), (boolean)false);
            String realmGet$jsonData = ((MessageCacheObjectRealmProxyInterface)object).realmGet$jsonData();
            if (realmGet$jsonData != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (String)realmGet$jsonData, (boolean)false);
                continue;
            }
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (boolean)false);
        }
    }

    public static MessageCacheObject createDetachedCopy(MessageCacheObject realmObject, int currentDepth, int maxDepth, Map<RealmModel, RealmObjectProxy.CacheData<RealmModel>> cache) {
        MessageCacheObject unmanagedObject;
        if (currentDepth > maxDepth || realmObject == null) {
            return null;
        }
        RealmObjectProxy.CacheData<RealmModel> cachedObject = cache.get(realmObject);
        if (cachedObject == null) {
            unmanagedObject = new MessageCacheObject();
            cache.put((RealmModel)realmObject, (RealmObjectProxy.CacheData<RealmModel>)new RealmObjectProxy.CacheData(currentDepth, (RealmModel)unmanagedObject));
        } else {
            if (currentDepth >= cachedObject.minDepth) {
                return (MessageCacheObject)cachedObject.object;
            }
            unmanagedObject = (MessageCacheObject)cachedObject.object;
            cachedObject.minDepth = currentDepth;
        }
        MessageCacheObjectRealmProxyInterface unmanagedCopy = unmanagedObject;
        MessageCacheObjectRealmProxyInterface realmSource = realmObject;
        unmanagedCopy.realmSet$recordID(realmSource.realmGet$recordID());
        unmanagedCopy.realmSet$conversationID(realmSource.realmGet$conversationID());
        unmanagedCopy.realmSet$creationDate(realmSource.realmGet$creationDate());
        unmanagedCopy.realmSet$editionDate(realmSource.realmGet$editionDate());
        unmanagedCopy.realmSet$sendDate(realmSource.realmGet$sendDate());
        unmanagedCopy.realmSet$deleted(realmSource.realmGet$deleted());
        unmanagedCopy.realmSet$alreadySyncToServer(realmSource.realmGet$alreadySyncToServer());
        unmanagedCopy.realmSet$fail(realmSource.realmGet$fail());
        unmanagedCopy.realmSet$jsonData(realmSource.realmGet$jsonData());
        return unmanagedObject;
    }

    static MessageCacheObject update(Realm realm, MessageCacheObject realmObject, MessageCacheObject newObject, Map<RealmModel, RealmObjectProxy> cache) {
        MessageCacheObjectRealmProxyInterface realmObjectTarget = realmObject;
        MessageCacheObjectRealmProxyInterface realmObjectSource = newObject;
        realmObjectTarget.realmSet$conversationID(realmObjectSource.realmGet$conversationID());
        realmObjectTarget.realmSet$creationDate(realmObjectSource.realmGet$creationDate());
        realmObjectTarget.realmSet$editionDate(realmObjectSource.realmGet$editionDate());
        realmObjectTarget.realmSet$sendDate(realmObjectSource.realmGet$sendDate());
        realmObjectTarget.realmSet$deleted(realmObjectSource.realmGet$deleted());
        realmObjectTarget.realmSet$alreadySyncToServer(realmObjectSource.realmGet$alreadySyncToServer());
        realmObjectTarget.realmSet$fail(realmObjectSource.realmGet$fail());
        realmObjectTarget.realmSet$jsonData(realmObjectSource.realmGet$jsonData());
        return realmObject;
    }

    public String toString() {
        if (!RealmObject.isValid((RealmModel)this)) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("MessageCacheObject = proxy[");
        stringBuilder.append("{recordID:");
        stringBuilder.append(this.realmGet$recordID() != null ? this.realmGet$recordID() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{conversationID:");
        stringBuilder.append(this.realmGet$conversationID() != null ? this.realmGet$conversationID() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{creationDate:");
        stringBuilder.append(this.realmGet$creationDate() != null ? this.realmGet$creationDate() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{editionDate:");
        stringBuilder.append(this.realmGet$editionDate() != null ? this.realmGet$editionDate() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{sendDate:");
        stringBuilder.append(this.realmGet$sendDate() != null ? this.realmGet$sendDate() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{deleted:");
        stringBuilder.append(this.realmGet$deleted());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{alreadySyncToServer:");
        stringBuilder.append(this.realmGet$alreadySyncToServer());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{fail:");
        stringBuilder.append(this.realmGet$fail());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{jsonData:");
        stringBuilder.append(this.realmGet$jsonData() != null ? this.realmGet$jsonData() : "null");
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public ProxyState<?> realmGet$proxyState() {
        return this.proxyState;
    }

    public int hashCode() {
        String realmName = this.proxyState.getRealm$realm().getPath();
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        long rowIndex = this.proxyState.getRow$realm().getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageCacheObjectRealmProxy aMessageCacheObject = (MessageCacheObjectRealmProxy)o;
        String path = this.proxyState.getRealm$realm().getPath();
        String otherPath = aMessageCacheObject.proxyState.getRealm$realm().getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        String otherTableName = aMessageCacheObject.proxyState.getRow$realm().getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.proxyState.getRow$realm().getIndex() == aMessageCacheObject.proxyState.getRow$realm().getIndex();
    }

    static {
        ArrayList<String> fieldNames = new ArrayList<String>(9);
        fieldNames.add("recordID");
        fieldNames.add("conversationID");
        fieldNames.add("creationDate");
        fieldNames.add("editionDate");
        fieldNames.add("sendDate");
        fieldNames.add("deleted");
        fieldNames.add("alreadySyncToServer");
        fieldNames.add("fail");
        fieldNames.add("jsonData");
        FIELD_NAMES = Collections.unmodifiableList(fieldNames);
    }

    static final class MessageCacheObjectColumnInfo
    extends ColumnInfo {
        long recordIDIndex;
        long conversationIDIndex;
        long creationDateIndex;
        long editionDateIndex;
        long sendDateIndex;
        long deletedIndex;
        long alreadySyncToServerIndex;
        long failIndex;
        long jsonDataIndex;

        MessageCacheObjectColumnInfo(OsSchemaInfo schemaInfo) {
            super(9);
            OsObjectSchemaInfo objectSchemaInfo = schemaInfo.getObjectSchemaInfo("MessageCacheObject");
            this.recordIDIndex = this.addColumnDetails("recordID", objectSchemaInfo);
            this.conversationIDIndex = this.addColumnDetails("conversationID", objectSchemaInfo);
            this.creationDateIndex = this.addColumnDetails("creationDate", objectSchemaInfo);
            this.editionDateIndex = this.addColumnDetails("editionDate", objectSchemaInfo);
            this.sendDateIndex = this.addColumnDetails("sendDate", objectSchemaInfo);
            this.deletedIndex = this.addColumnDetails("deleted", objectSchemaInfo);
            this.alreadySyncToServerIndex = this.addColumnDetails("alreadySyncToServer", objectSchemaInfo);
            this.failIndex = this.addColumnDetails("fail", objectSchemaInfo);
            this.jsonDataIndex = this.addColumnDetails("jsonData", objectSchemaInfo);
        }

        MessageCacheObjectColumnInfo(ColumnInfo src, boolean mutable) {
            super(src, mutable);
            this.copy(src, this);
        }

        protected final ColumnInfo copy(boolean mutable) {
            return new MessageCacheObjectColumnInfo(this, mutable);
        }

        protected final void copy(ColumnInfo rawSrc, ColumnInfo rawDst) {
            MessageCacheObjectColumnInfo src = (MessageCacheObjectColumnInfo)rawSrc;
            MessageCacheObjectColumnInfo dst = (MessageCacheObjectColumnInfo)rawDst;
            dst.recordIDIndex = src.recordIDIndex;
            dst.conversationIDIndex = src.conversationIDIndex;
            dst.creationDateIndex = src.creationDateIndex;
            dst.editionDateIndex = src.editionDateIndex;
            dst.sendDateIndex = src.sendDateIndex;
            dst.deletedIndex = src.deletedIndex;
            dst.alreadySyncToServerIndex = src.alreadySyncToServerIndex;
            dst.failIndex = src.failIndex;
            dst.jsonDataIndex = src.jsonDataIndex;
        }
    }
}

