/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.Publisher;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface SwitchMapSignal<T> {
    public boolean isSwitched();

    @Nullable
    public T onNext();

    public static <T, R> Function<T, Publisher<? extends SwitchMapSignal<R>>> toSwitchFunction(final Function<? super T, ? extends Publisher<? extends R>> function) {
        return new Function<T, Publisher<? extends SwitchMapSignal<R>>>(){
            private boolean seenFirstPublisher;

            @Override
            @Nullable
            public Publisher<? extends SwitchMapSignal<R>> apply(T t) {
                Publisher rawPublisher = (Publisher)function.apply(t);
                if (rawPublisher == null) {
                    return null;
                }
                boolean localSeenFirstPublisher = this.seenFirstPublisher;
                this.seenFirstPublisher = true;
                if (localSeenFirstPublisher) {
                    return Publisher.defer(() -> {
                        boolean[] seenOnNext = new boolean[1];
                        return rawPublisher.map(res -> {
                            final boolean localSeenOnNext = seenOnNext[0];
                            seenOnNext[0] = true;
                            return new SwitchMapSignal<R>(){

                                @Override
                                public boolean isSwitched() {
                                    return !localSeenOnNext;
                                }

                                @Override
                                @Nullable
                                public R onNext() {
                                    return res;
                                }
                            };
                        }).shareContextOnSubscribe();
                    });
                }
                return rawPublisher.map(res -> new SwitchMapSignal<R>(){

                    @Override
                    public boolean isSwitched() {
                        return false;
                    }

                    @Override
                    @Nullable
                    public R onNext() {
                        return res;
                    }
                });
            }
        };
    }
}

