/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.MergedCancellableWithSubscription;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RedoPublisher;
import io.servicetalk.concurrent.api.SequentialSubscription;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.Objects;
import java.util.function.BiFunction;

final class RedoWhenPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final boolean terminateOnNextException;
    private final Publisher<T> original;
    private final BiFunction<Integer, TerminalNotification, Completable> shouldRedo;
    private final boolean forRetry;

    RedoWhenPublisher(Publisher<T> original, boolean forRetry, boolean terminateOnNextException, BiFunction<Integer, TerminalNotification, Completable> shouldRedo) {
        this.original = original;
        this.forRetry = forRetry;
        this.terminateOnNextException = terminateOnNextException;
        this.shouldRedo = shouldRedo;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new RedoSubscriber<T>(this.terminateOnNextException, new SequentialSubscription(), 0, subscriber, capturedContext, contextProvider, this), capturedContext, contextProvider);
    }

    private static final class RedoSubscriber<T>
    extends RedoPublisher.AbstractRedoSubscriber<T> {
        private final SequentialCancellable cancellable;
        private final RedoWhenPublisher<T> redoPublisher;
        private final CapturedContext capturedContext;
        private final AsyncContextProvider contextProvider;
        private final CompletableSource.Subscriber completableSubscriber = new CompletableSource.Subscriber(){

            public void onSubscribe(Cancellable completableCancellable) {
                cancellable.nextCancellable(completableCancellable);
            }

            public void onComplete() {
                redoPublisher.original.delegateSubscribeWithContext(this, capturedContext, contextProvider);
            }

            public void onError(Throwable t) {
                if (!redoPublisher.forRetry) {
                    subscriber.onComplete();
                } else {
                    subscriber.onError(t);
                }
            }
        };

        RedoSubscriber(boolean terminateOnNextException, SequentialSubscription subscription, int redoCount, PublisherSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider, RedoWhenPublisher<T> redoPublisher) {
            super(terminateOnNextException, subscription, redoCount, subscriber);
            this.redoPublisher = redoPublisher;
            this.capturedContext = capturedContext;
            this.contextProvider = contextProvider;
            this.cancellable = new SequentialCancellable();
        }

        @Override
        void onError0(Throwable t) {
            if (!((RedoWhenPublisher)this.redoPublisher).forRetry) {
                this.subscriber.onError(t);
                return;
            }
            TerminalNotification terminalNotification = TerminalNotification.error((Throwable)t);
            this.redoIfRequired(terminalNotification);
        }

        @Override
        void onComplete0() {
            if (((RedoWhenPublisher)this.redoPublisher).forRetry) {
                this.subscriber.onComplete();
                return;
            }
            this.redoIfRequired(TerminalNotification.complete());
        }

        @Override
        PublisherSource.Subscription decorate(PublisherSource.Subscription s) {
            return new MergedCancellableWithSubscription(s, (Cancellable)this.cancellable);
        }

        private void redoIfRequired(TerminalNotification terminalNotification) {
            Completable redoDecider;
            try {
                redoDecider = Objects.requireNonNull((Completable)((RedoWhenPublisher)this.redoPublisher).shouldRedo.apply(++this.redoCount, terminalNotification), () -> "Redo decider " + ((RedoWhenPublisher)this.redoPublisher).shouldRedo + " returned null");
            }
            catch (Throwable cause) {
                Throwable originalCause = terminalNotification.cause();
                if (originalCause != null) {
                    ThrowableUtils.addSuppressed((Throwable)cause, (Throwable)originalCause);
                }
                this.subscriber.onError(cause);
                return;
            }
            redoDecider.subscribeInternal(this.completableSubscriber);
        }
    }
}

