/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisher;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import javax.annotation.Nullable;

final class FromNPublisher<T>
extends AbstractSynchronousPublisher<T> {
    private static final Object UNUSED_REF = new Object();
    @Nullable
    private final T v1;
    @Nullable
    private final T v2;
    @Nullable
    private final T v3;

    FromNPublisher(@Nullable T v1, @Nullable T v2) {
        this.v1 = UNUSED_REF;
        this.v2 = v1;
        this.v3 = v2;
    }

    FromNPublisher(@Nullable T v1, @Nullable T v2, @Nullable T v3) {
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
    }

    @Override
    void doSubscribe(PublisherSource.Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe((PublisherSource.Subscription)new NValueSubscription(subscriber));
        }
        catch (Throwable cause) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)cause);
        }
    }

    private final class NValueSubscription
    implements PublisherSource.Subscription {
        private static final byte ZERO = 0;
        private static final byte ONE = 1;
        private static final byte TWO = 2;
        private static final byte TERMINATED = 3;
        private byte requested;
        private byte state;
        private final PublisherSource.Subscriber<? super T> subscriber;

        private NValueSubscription(PublisherSource.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
            if (FromNPublisher.this.v1 == UNUSED_REF) {
                this.requested = 1;
                this.state = 1;
            }
        }

        public void cancel() {
            this.state = (byte)3;
        }

        public void request(long n) {
            if (this.state() == 3) {
                return;
            }
            if (!SubscriberUtils.isRequestNValid((long)n)) {
                this.state = (byte)3;
                this.subscriber.onError((Throwable)SubscriberUtils.newExceptionForInvalidRequestN((long)n));
                return;
            }
            if (this.requested == 3) {
                return;
            }
            this.requested = (byte)Math.min(3L, FlowControlUtils.addWithOverflowProtection((long)this.requested, (long)n));
            if (this.ignoreRequests()) {
                return;
            }
            this.ignoreRequests(true);
            while (this.state() < this.requested) {
                if (this.state() == 0) {
                    this.deliver(FromNPublisher.this.v1, (byte)1);
                    continue;
                }
                if (this.state() == 1) {
                    this.deliver(FromNPublisher.this.v2, (byte)2);
                    continue;
                }
                if (this.state() != 2) continue;
                if (this.deliver(FromNPublisher.this.v3, (byte)3)) {
                    this.subscriber.onComplete();
                }
                return;
            }
            this.ignoreRequests(false);
        }

        private boolean deliver(@Nullable T value, byte nextState) {
            this.state = (byte)(this.state & 0x10 | nextState);
            try {
                this.subscriber.onNext(value);
                return true;
            }
            catch (Throwable cause) {
                this.state = (byte)3;
                this.subscriber.onError(cause);
                return false;
            }
        }

        private byte state() {
            return (byte)(this.state & 0xF);
        }

        private boolean ignoreRequests() {
            return (this.state & 0x10) > 0;
        }

        private void ignoreRequests(boolean ignore) {
            this.state = ignore ? (byte)(this.state | 0x10) : (byte)(this.state & 0xF);
        }
    }
}

