/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.Completable;
import java.util.Objects;

public class DelegatingAsyncCloseable<T extends AsyncCloseable>
implements AsyncCloseable {
    private final T delegate;

    public DelegatingAsyncCloseable(T delegate) {
        this.delegate = (AsyncCloseable)Objects.requireNonNull(delegate);
    }

    protected T delegate() {
        return this.delegate;
    }

    @Override
    public Completable closeAsync() {
        return this.delegate.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.delegate.closeAsyncGracefully();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{delegate=" + this.delegate() + "}";
    }
}

