/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import java.util.Objects;
import java.util.function.Function;

final class ContextPreservingFunction<T, U>
implements Function<T, U> {
    private final CapturedContext capturedContext;
    private final Function<T, U> delegate;

    ContextPreservingFunction(Function<T, U> delegate, CapturedContext capturedContext) {
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public U apply(T t) {
        try (Scope ignored = this.capturedContext.attachContext();){
            U u = this.delegate.apply(t);
            return u;
        }
    }
}

