/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import java.util.Objects;
import java.util.concurrent.Callable;

final class ContextPreservingCallable<V>
implements Callable<V> {
    private final CapturedContext capturedContext;
    private final Callable<V> delegate;

    ContextPreservingCallable(Callable<V> delegate) {
        this(delegate, AsyncContext.provider().captureContext());
    }

    ContextPreservingCallable(Callable<V> delegate, CapturedContext capturedContext) {
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public V call() throws Exception {
        try (Scope ignored = this.capturedContext.attachContext();){
            V v = this.delegate.call();
            return v;
        }
    }
}

