/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import java.util.Objects;
import java.util.function.BiConsumer;

final class ContextPreservingBiConsumer<T, U>
implements BiConsumer<T, U> {
    private final CapturedContext capturedContext;
    private final BiConsumer<T, U> delegate;

    ContextPreservingBiConsumer(BiConsumer<T, U> delegate, CapturedContext capturedContext) {
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void accept(T t, U u) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.delegate.accept(t, u);
        }
    }
}

