/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class CompositeExceptionUtils {
    private static final int DEFAULT_MAX_EXCEPTIONS = 1;

    private CompositeExceptionUtils() {
    }

    static <T> Throwable addPendingError(AtomicReferenceFieldUpdater<T, Throwable> causeUpdater, AtomicIntegerFieldUpdater<T> countUpdater, T owner, int maxDelayedErrors, Throwable causeToAdd) {
        Throwable currPendingError = causeUpdater.get(owner);
        if (currPendingError == null) {
            if (causeUpdater.compareAndSet(owner, null, causeToAdd)) {
                currPendingError = causeToAdd;
            } else {
                currPendingError = causeUpdater.get(owner);
                assert (currPendingError != null);
                CompositeExceptionUtils.addPendingError(countUpdater, owner, maxDelayedErrors, currPendingError, causeToAdd);
            }
        } else {
            CompositeExceptionUtils.addPendingError(countUpdater, owner, maxDelayedErrors, currPendingError, causeToAdd);
        }
        return currPendingError;
    }

    private static <T> void addPendingError(AtomicIntegerFieldUpdater<T> updater, T owner, int maxDelayedErrors, Throwable original, Throwable causeToAdd) {
        int size;
        if (original == causeToAdd) {
            return;
        }
        while ((size = updater.get(owner)) < maxDelayedErrors) {
            if (!updater.compareAndSet(owner, size, size + 1)) continue;
            original.addSuppressed(causeToAdd);
            break;
        }
    }

    static int maxDelayedErrors(boolean delayError) {
        return delayError ? 1 : 0;
    }
}

