/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.webflux;

import io.sentry.Breadcrumb;
import io.sentry.CustomSamplingContext;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.ITransaction;
import io.sentry.NoOpScopes;
import io.sentry.Sentry;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.spring.webflux.SentryRequestResolver;
import io.sentry.spring.webflux.TransactionNameProvider;
import io.sentry.util.Objects;
import io.sentry.util.SpanUtils;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@ApiStatus.Experimental
public final class SentryWebFilter
implements WebFilter {
    public static final String SENTRY_SCOPES_KEY = "sentry-scopes";
    @Deprecated
    public static final String SENTRY_HUB_KEY = "sentry-scopes";
    private static final String TRANSACTION_OP = "http.server";
    private static final String TRACE_ORIGIN = "auto.spring.webflux";
    @NotNull
    private final SentryRequestResolver sentryRequestResolver;

    public SentryWebFilter(@NotNull IScopes scopes) {
        Objects.requireNonNull((Object)scopes, (String)"scopes are required");
        this.sentryRequestResolver = new SentryRequestResolver(scopes);
    }

    public Mono<Void> filter(@NotNull ServerWebExchange serverWebExchange, @NotNull WebFilterChain webFilterChain) {
        @NotNull IScopes requestScopes = Sentry.forkedRootScopes((String)"request.webflux");
        if (!requestScopes.isEnabled() || this.isIgnored(requestScopes)) {
            return webFilterChain.filter(serverWebExchange);
        }
        boolean isTracingEnabled = requestScopes.getOptions().isTracingEnabled();
        @NotNull ServerHttpRequest request = serverWebExchange.getRequest();
        @NotNull HttpHeaders headers = request.getHeaders();
        @Nullable String sentryTraceHeader = headers.getFirst("sentry-trace");
        @Nullable List baggageHeaders = headers.get((Object)"baggage");
        @Nullable TransactionContext transactionContext = requestScopes.continueTrace(sentryTraceHeader, baggageHeaders);
        ITransaction transaction = isTracingEnabled && this.shouldTraceRequest(requestScopes, request) ? this.startTransaction(requestScopes, request, transactionContext) : null;
        return webFilterChain.filter(serverWebExchange).doFinally(__ -> {
            if (transaction != null) {
                this.finishTransaction(serverWebExchange, transaction);
            }
            Sentry.setCurrentScopes((IScopes)NoOpScopes.getInstance());
        }).doOnError(e -> {
            if (transaction != null) {
                transaction.setStatus(SpanStatus.INTERNAL_ERROR);
                transaction.setThrowable(e);
            }
        }).doFirst(() -> {
            serverWebExchange.getAttributes().put("sentry-scopes", requestScopes);
            Sentry.setCurrentScopes((IScopes)requestScopes);
            ServerHttpResponse response = serverWebExchange.getResponse();
            Hint hint = new Hint();
            hint.set("webFluxFilter:request", (Object)request);
            hint.set("webFluxFilter:response", (Object)response);
            @NotNull String methodName = request.getMethod() != null ? request.getMethod().name() : "unknown";
            requestScopes.addBreadcrumb(Breadcrumb.http((String)request.getURI().toString(), (String)methodName), hint);
            requestScopes.configureScope(scope -> scope.setRequest(this.sentryRequestResolver.resolveSentryRequest(request)));
        });
    }

    private boolean isIgnored(@NotNull IScopes scopes) {
        return SpanUtils.isIgnored((List)scopes.getOptions().getIgnoredSpanOrigins(), (String)TRACE_ORIGIN);
    }

    private boolean shouldTraceRequest(@NotNull IScopes scopes, @NotNull ServerHttpRequest request) {
        return scopes.getOptions().isTraceOptionsRequests() || !HttpMethod.OPTIONS.equals((Object)request.getMethod());
    }

    @NotNull
    private ITransaction startTransaction(@NotNull IScopes scopes, @NotNull ServerHttpRequest request, @Nullable TransactionContext transactionContext) {
        @NotNull String name = request.getMethod() + " " + request.getURI().getPath();
        @NotNull CustomSamplingContext customSamplingContext = new CustomSamplingContext();
        customSamplingContext.set("request", (Object)request);
        TransactionOptions transactionOptions = new TransactionOptions();
        transactionOptions.setCustomSamplingContext(customSamplingContext);
        transactionOptions.setBindToScope(true);
        transactionOptions.setOrigin(TRACE_ORIGIN);
        if (transactionContext != null) {
            transactionContext.setName(name);
            transactionContext.setTransactionNameSource(TransactionNameSource.URL);
            transactionContext.setOperation(TRANSACTION_OP);
            return scopes.startTransaction(transactionContext, transactionOptions);
        }
        return scopes.startTransaction(new TransactionContext(name, TransactionNameSource.URL, TRANSACTION_OP), transactionOptions);
    }

    private void finishTransaction(ServerWebExchange exchange, ITransaction transaction) {
        Integer rawStatusCode;
        ServerHttpResponse response;
        String transactionName = TransactionNameProvider.provideTransactionName(exchange);
        if (transactionName != null) {
            transaction.setName(transactionName, TransactionNameSource.ROUTE);
            transaction.setOperation(TRANSACTION_OP);
        }
        if ((response = exchange.getResponse()) != null && (rawStatusCode = response.getRawStatusCode()) != null) {
            transaction.getContexts().withResponse(sentryResponse -> sentryResponse.setStatusCode(rawStatusCode));
            if (transaction.getStatus() == null) {
                transaction.setStatus(SpanStatus.fromHttpStatusCode((int)rawStatusCode));
            }
        }
        transaction.finish();
    }
}

