/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.webflux;

import io.sentry.Baggage;
import io.sentry.Breadcrumb;
import io.sentry.CustomSamplingContext;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ILogger;
import io.sentry.ITransaction;
import io.sentry.NoOpHub;
import io.sentry.Sentry;
import io.sentry.SentryLevel;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.exception.InvalidSentryTraceHeaderException;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.spring.webflux.SentryRequestResolver;
import io.sentry.spring.webflux.TransactionNameProvider;
import io.sentry.util.Objects;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@ApiStatus.Experimental
public final class SentryWebFilter
implements WebFilter {
    public static final String SENTRY_HUB_KEY = "sentry-hub";
    private static final String TRANSACTION_OP = "http.server";
    @NotNull
    private final SentryRequestResolver sentryRequestResolver;

    public SentryWebFilter(@NotNull IHub hub) {
        Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.sentryRequestResolver = new SentryRequestResolver(hub);
    }

    public Mono<Void> filter(@NotNull ServerWebExchange serverWebExchange, @NotNull WebFilterChain webFilterChain) {
        @NotNull IHub requestHub = Sentry.cloneMainHub();
        if (!requestHub.isEnabled()) {
            return webFilterChain.filter(serverWebExchange);
        }
        boolean isTracingEnabled = requestHub.getOptions().isTracingEnabled();
        @NotNull ServerHttpRequest request = serverWebExchange.getRequest();
        ITransaction transaction = isTracingEnabled && this.shouldTraceRequest(requestHub, request) ? this.startTransaction(requestHub, request) : null;
        return webFilterChain.filter(serverWebExchange).doFinally(__ -> {
            if (transaction != null) {
                this.finishTransaction(serverWebExchange, transaction);
            }
            requestHub.popScope();
            Sentry.setCurrentHub((IHub)NoOpHub.getInstance());
        }).doOnError(e -> {
            if (transaction != null) {
                transaction.setStatus(SpanStatus.INTERNAL_ERROR);
                transaction.setThrowable(e);
            }
        }).doFirst(() -> {
            serverWebExchange.getAttributes().put(SENTRY_HUB_KEY, requestHub);
            Sentry.setCurrentHub((IHub)requestHub);
            requestHub.pushScope();
            ServerHttpResponse response = serverWebExchange.getResponse();
            @NotNull Hint hint = new Hint();
            hint.set("webFluxFilter:request", (Object)request);
            hint.set("webFluxFilter:response", (Object)response);
            @Nullable String methodName = request.getMethod() != null ? request.getMethod().name() : "unknown";
            requestHub.addBreadcrumb(Breadcrumb.http((String)request.getURI().toString(), (String)methodName), hint);
            requestHub.configureScope(scope -> scope.setRequest(this.sentryRequestResolver.resolveSentryRequest(request)));
        });
    }

    private boolean shouldTraceRequest(@NotNull IHub hub, @NotNull ServerHttpRequest request) {
        return hub.getOptions().isTraceOptionsRequests() || !HttpMethod.OPTIONS.equals((Object)request.getMethod());
    }

    @NotNull
    private ITransaction startTransaction(@NotNull IHub hub, @NotNull ServerHttpRequest request) {
        @NotNull HttpHeaders headers = request.getHeaders();
        @Nullable List sentryTraceHeaders = headers.get((Object)"sentry-trace");
        @Nullable List baggageHeaders = headers.get((Object)"baggage");
        @NotNull String name = request.getMethod() + " " + request.getURI().getPath();
        @NotNull CustomSamplingContext customSamplingContext = new CustomSamplingContext();
        customSamplingContext.set("request", (Object)request);
        TransactionOptions transactionOptions = new TransactionOptions();
        transactionOptions.setCustomSamplingContext(customSamplingContext);
        transactionOptions.setBindToScope(true);
        if (sentryTraceHeaders != null && sentryTraceHeaders.size() > 0) {
            @NotNull Baggage baggage = Baggage.fromHeader((List)baggageHeaders, (ILogger)hub.getOptions().getLogger());
            try {
                @NotNull TransactionContext contexts = TransactionContext.fromSentryTrace((String)name, (TransactionNameSource)TransactionNameSource.URL, (String)TRANSACTION_OP, (SentryTraceHeader)new SentryTraceHeader((String)sentryTraceHeaders.get(0)), (Baggage)baggage, null);
                return hub.startTransaction(contexts, transactionOptions);
            }
            catch (InvalidSentryTraceHeaderException e) {
                hub.getOptions().getLogger().log(SentryLevel.DEBUG, (Throwable)e, "Failed to parse Sentry trace header: %s", new Object[]{e.getMessage()});
            }
        }
        return hub.startTransaction(new TransactionContext(name, TransactionNameSource.URL, TRANSACTION_OP), transactionOptions);
    }

    private void finishTransaction(ServerWebExchange exchange, ITransaction transaction) {
        Integer rawStatusCode;
        ServerHttpResponse response;
        String transactionName = TransactionNameProvider.provideTransactionName(exchange);
        if (transactionName != null) {
            transaction.setName(transactionName, TransactionNameSource.ROUTE);
            transaction.setOperation(TRANSACTION_OP);
        }
        if (transaction.getStatus() == null && (response = exchange.getResponse()) != null && (rawStatusCode = response.getRawStatusCode()) != null) {
            transaction.setStatus(SpanStatus.fromHttpStatusCode((int)rawStatusCode));
        }
        transaction.finish();
    }
}

