/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.EventProcessor;
import io.sentry.IpAddressUtils;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEvent;
import io.sentry.SentryOptions;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import io.sentry.spring.SentryUserProvider;
import io.sentry.util.Objects;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class SentryUserProviderEventProcessor
implements EventProcessor {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final SentryUserProvider sentryUserProvider;

    public SentryUserProviderEventProcessor(@NotNull SentryOptions options, @NotNull SentryUserProvider sentryUserProvider) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"options is required");
        this.sentryUserProvider = (SentryUserProvider)Objects.requireNonNull((Object)sentryUserProvider, (String)"sentryUserProvider is required");
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @Nullable Object hint) {
        this.mergeUser((SentryBaseEvent)event);
        return event;
    }

    @NotNull
    @ApiStatus.Internal
    public SentryUserProvider getSentryUserProvider() {
        return this.sentryUserProvider;
    }

    private void mergeUser(@NotNull SentryBaseEvent event) {
        User existingUser;
        User user = this.sentryUserProvider.provideUser();
        if (user != null) {
            existingUser = Optional.ofNullable(event.getUser()).orElseGet(User::new);
            Optional.ofNullable(user.getEmail()).ifPresent(arg_0 -> ((User)existingUser).setEmail(arg_0));
            Optional.ofNullable(user.getId()).ifPresent(arg_0 -> ((User)existingUser).setId(arg_0));
            Optional.ofNullable(user.getIpAddress()).ifPresent(arg_0 -> ((User)existingUser).setIpAddress(arg_0));
            Optional.ofNullable(user.getUsername()).ifPresent(arg_0 -> ((User)existingUser).setUsername(arg_0));
            if (user.getOthers() != null && !user.getOthers().isEmpty()) {
                ConcurrentHashMap<String, String> existingUserOthers = existingUser.getOthers();
                if (existingUserOthers == null) {
                    existingUserOthers = new ConcurrentHashMap<String, String>();
                }
                for (Map.Entry entry : user.getOthers().entrySet()) {
                    existingUserOthers.put((String)entry.getKey(), (String)entry.getValue());
                }
                existingUser.setOthers(existingUserOthers);
            }
            event.setUser(existingUser);
        }
        if (this.options.isSendDefaultPii() && (existingUser = event.getUser()) != null && IpAddressUtils.isDefault((String)existingUser.getIpAddress())) {
            existingUser.setIpAddress(null);
        }
    }

    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @Nullable Object hint) {
        this.mergeUser((SentryBaseEvent)transaction);
        return transaction;
    }
}

