/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.util.Objects;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class SentrySpanClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    @NotNull
    private final IHub hub;

    public SentrySpanClientHttpRequestInterceptor(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) throws IOException {
        ISpan span;
        Integer responseStatusCode = null;
        ISpan activeSpan = this.hub.getSpan();
        if (activeSpan == null) {
            ClientHttpResponse clientHttpResponse = execution.execute(request, body);
            this.addBreadcrumb(request, body, responseStatusCode);
            return clientHttpResponse;
        }
        {
            catch (Throwable throwable) {
                this.addBreadcrumb(request, body, responseStatusCode);
                throw throwable;
            }
            span = activeSpan.startChild("http.client");
            span.setDescription(request.getMethodValue() + " " + request.getURI());
            SentryTraceHeader sentryTraceHeader = span.toSentryTrace();
            request.getHeaders().add(sentryTraceHeader.getName(), sentryTraceHeader.getValue());
            try {
                ClientHttpResponse response = execution.execute(request, body);
                span.setStatus(SpanStatus.fromHttpStatusCode((int)response.getRawStatusCode()));
                responseStatusCode = response.getRawStatusCode();
                ClientHttpResponse clientHttpResponse = response;
                return clientHttpResponse;
            }
            catch (Exception e) {}
            {
                span.setThrowable((Throwable)e);
                span.setStatus(SpanStatus.INTERNAL_ERROR);
                throw e;
            }
        }
        finally {
            span.finish();
        }
    }

    private void addBreadcrumb(@NotNull HttpRequest request, @NotNull byte[] body, @Nullable Integer responseStatusCode) {
        Breadcrumb breadcrumb = Breadcrumb.http((String)request.getURI().toString(), (String)request.getMethodValue(), (Integer)responseStatusCode);
        breadcrumb.setData("requestBodySize", (Object)body.length);
        this.hub.addBreadcrumb(breadcrumb);
    }
}

