/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.IHub;
import io.sentry.IpAddressUtils;
import io.sentry.protocol.User;
import io.sentry.spring.SentryUserProvider;
import io.sentry.util.Objects;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class SentryUserFilter
implements Filter {
    @NotNull
    private final IHub hub;
    @NotNull
    private final List<SentryUserProvider> sentryUserProviders;

    public SentryUserFilter(@NotNull IHub hub, @NotNull List<SentryUserProvider> sentryUserProviders) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.sentryUserProviders = (List)Objects.requireNonNull(sentryUserProviders, (String)"sentryUserProviders list is required");
    }

    public void doFilter(@NotNull ServletRequest request, @NotNull ServletResponse response, @NotNull FilterChain chain) throws IOException, ServletException {
        User user = new User();
        for (SentryUserProvider provider : this.sentryUserProviders) {
            this.apply(user, provider.provideUser());
        }
        if (this.hub.getOptions().isSendDefaultPii() && IpAddressUtils.isDefault((String)user.getIpAddress())) {
            user.setIpAddress(null);
        }
        this.hub.setUser(user);
        chain.doFilter(request, response);
    }

    private void apply(@NotNull User existingUser, @Nullable User userFromProvider) {
        if (userFromProvider != null) {
            Optional.ofNullable(userFromProvider.getEmail()).ifPresent(arg_0 -> ((User)existingUser).setEmail(arg_0));
            Optional.ofNullable(userFromProvider.getId()).ifPresent(arg_0 -> ((User)existingUser).setId(arg_0));
            Optional.ofNullable(userFromProvider.getIpAddress()).ifPresent(arg_0 -> ((User)existingUser).setIpAddress(arg_0));
            Optional.ofNullable(userFromProvider.getUsername()).ifPresent(arg_0 -> ((User)existingUser).setUsername(arg_0));
            if (userFromProvider.getOthers() != null && !userFromProvider.getOthers().isEmpty()) {
                if (existingUser.getOthers() == null) {
                    existingUser.setOthers(new ConcurrentHashMap());
                }
                for (Map.Entry entry : userFromProvider.getOthers().entrySet()) {
                    existingUser.getOthers().put((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    @VisibleForTesting
    @NotNull
    public List<SentryUserProvider> getSentryUserProviders() {
        return this.sentryUserProviders;
    }
}

