/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.spring.tracing.SentryTransaction;
import io.sentry.util.Objects;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

@ApiStatus.Internal
public class SentryTransactionAdvice
implements MethodInterceptor {
    @NotNull
    private final IHub hub;

    public SentryTransactionAdvice(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
        Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)invocation.getMethod(), invocation.getThis().getClass());
        @Nullable SentryTransaction sentryTransaction = (SentryTransaction)AnnotationUtils.findAnnotation((Method)mostSpecificMethod, SentryTransaction.class);
        String name = this.resolveTransactionName(invocation, sentryTransaction);
        boolean isTransactionActive = this.isTransactionActive();
        if (isTransactionActive) {
            return invocation.proceed();
        }
        io.sentry.SentryTransaction transaction = this.hub.startTransaction(name);
        if (sentryTransaction != null && !StringUtils.isEmpty((Object)sentryTransaction.op())) {
            transaction.setOperation(sentryTransaction.op());
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            transaction.finish();
        }
    }

    @NotNull
    private String resolveTransactionName(MethodInvocation invocation, @Nullable SentryTransaction sentryTransaction) {
        return sentryTransaction == null || StringUtils.isEmpty((Object)sentryTransaction.value()) ? invocation.getMethod().getDeclaringClass().getSimpleName() + "." + invocation.getMethod().getName() : sentryTransaction.value();
    }

    private boolean isTransactionActive() {
        AtomicBoolean isTransactionActiveRef = new AtomicBoolean(false);
        this.hub.configureScope(scope -> {
            ISpan span = scope.getSpan();
            if (span != null) {
                isTransactionActiveRef.set(true);
            }
        });
        return isTransactionActiveRef.get();
    }
}

