/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.Breadcrumb;
import io.sentry.EventProcessor;
import io.sentry.IHub;
import io.sentry.SentryOptions;
import io.sentry.spring.SentryRequestHttpServletRequestProcessor;
import io.sentry.util.Objects;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class SentryRequestFilter
extends OncePerRequestFilter
implements Ordered {
    @NotNull
    private final IHub hub;
    @NotNull
    private final SentryOptions options;

    public SentryRequestFilter(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"options are required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) throws ServletException, IOException {
        this.hub.pushScope();
        this.hub.addBreadcrumb(Breadcrumb.http((String)request.getRequestURI(), (String)request.getMethod()));
        this.hub.configureScope(scope -> scope.addEventProcessor((EventProcessor)new SentryRequestHttpServletRequestProcessor(request, this.options)));
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.hub.popScope();
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

