/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import io.sentry.IContinuousProfiler;
import io.sentry.IProfileConverter;
import io.sentry.NoOpContinuousProfiler;
import io.sentry.NoOpProfileConverter;
import io.sentry.Sentry;
import io.sentry.SentryOptions;
import io.sentry.util.InitUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class SentryProfilerConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"sentryOpenTelemetryProfilerConfiguration"})
    public IContinuousProfiler sentryOpenTelemetryProfilerConfiguration() {
        SentryOptions options = Sentry.getGlobalScope().getOptions();
        NoOpContinuousProfiler profiler = NoOpContinuousProfiler.getInstance();
        if (Sentry.isEnabled()) {
            return InitUtil.initializeProfiler((SentryOptions)options);
        }
        return profiler;
    }

    @Bean
    @ConditionalOnMissingBean(name={"sentryOpenTelemetryProfilerConverterConfiguration"})
    public IProfileConverter sentryOpenTelemetryProfilerConverterConfiguration() {
        SentryOptions options = Sentry.getGlobalScope().getOptions();
        NoOpProfileConverter converter = NoOpProfileConverter.getInstance();
        if (Sentry.isEnabled()) {
            return InitUtil.initializeProfileConverter((SentryOptions)options);
        }
        return converter;
    }
}

