/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.tracing;

import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.ISpan;
import io.sentry.SpanOptions;
import io.sentry.SpanStatus;
import io.sentry.util.Objects;
import io.sentry.util.TracingUtils;
import io.sentry.util.UrlUtils;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class SentrySpanClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final String TRACE_ORIGIN_REST_TEMPLATE = "auto.http.spring_jakarta.resttemplate";
    private static final String TRACE_ORIGIN_REST_CLIENT = "auto.http.spring_jakarta.restclient";
    @NotNull
    private final IScopes scopes;
    @NotNull
    private final String traceOrigin;

    public SentrySpanClientHttpRequestInterceptor(@NotNull IScopes scopes) {
        this(scopes, true);
    }

    public SentrySpanClientHttpRequestInterceptor(@NotNull IScopes scopes, @NotNull boolean isRestTemplate) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        this.traceOrigin = isRestTemplate ? TRACE_ORIGIN_REST_TEMPLATE : TRACE_ORIGIN_REST_CLIENT;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) throws IOException {
        ISpan span;
        Integer responseStatusCode = null;
        ClientHttpResponse response = null;
        ISpan activeSpan = this.scopes.getSpan();
        if (activeSpan == null) {
            this.maybeAddTracingHeaders(request, null);
            ClientHttpResponse clientHttpResponse = execution.execute(request, body);
            this.addBreadcrumb(request, body, responseStatusCode, response);
            return clientHttpResponse;
        }
        {
            catch (Throwable throwable) {
                this.addBreadcrumb(request, body, responseStatusCode, response);
                throw throwable;
            }
            @NotNull SpanOptions spanOptions = new SpanOptions();
            spanOptions.setOrigin(this.traceOrigin);
            span = activeSpan.startChild("http.client", null, spanOptions);
            String methodName = request.getMethod() != null ? request.getMethod().name() : "unknown";
            // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)request.getURI().toString());
            span.setDescription(methodName + " " + urlDetails.getUrlOrFallback());
            span.setData("http.request.method", (Object)methodName.toUpperCase(Locale.ROOT));
            urlDetails.applyToSpan(span);
            this.maybeAddTracingHeaders(request, span);
            try {
                response = execution.execute(request, body);
                span.setData("http.response.status_code", (Object)response.getStatusCode().value());
                span.setStatus(SpanStatus.fromHttpStatusCode((int)response.getStatusCode().value()));
                responseStatusCode = response.getStatusCode().value();
                ClientHttpResponse clientHttpResponse = response;
                return clientHttpResponse;
            }
            catch (Throwable e) {}
            {
                span.setThrowable(e);
                span.setStatus(SpanStatus.INTERNAL_ERROR);
                throw e;
            }
        }
        finally {
            span.finish();
        }
    }

    private void maybeAddTracingHeaders(@NotNull HttpRequest request, @Nullable ISpan span) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable TracingUtils.TracingHeaders tracingHeaders = TracingUtils.traceIfAllowed((IScopes)this.scopes, (String)request.getURI().toString(), (List)request.getHeaders().get((Object)"baggage"), (ISpan)span);
        if (tracingHeaders != null) {
            request.getHeaders().add(tracingHeaders.getSentryTraceHeader().getName(), tracingHeaders.getSentryTraceHeader().getValue());
            @Nullable BaggageHeader baggageHeader = tracingHeaders.getBaggageHeader();
            if (baggageHeader != null) {
                request.getHeaders().set(baggageHeader.getName(), baggageHeader.getValue());
            }
        }
    }

    private void addBreadcrumb(@NotNull HttpRequest request, @NotNull byte[] body, @Nullable Integer responseStatusCode, @Nullable ClientHttpResponse response) {
        String methodName = request.getMethod() != null ? request.getMethod().name() : "unknown";
        Breadcrumb breadcrumb = Breadcrumb.http((String)request.getURI().toString(), (String)methodName, (Integer)responseStatusCode);
        breadcrumb.setData("request_body_size", (Object)body.length);
        Hint hint = new Hint();
        hint.set("springRequestInterceptor:request", (Object)request);
        hint.set("springRequestInterceptor:requestBody", (Object)body);
        if (response != null) {
            hint.set("springRequestInterceptor:response", (Object)response);
        }
        this.scopes.addBreadcrumb(breadcrumb, hint);
    }
}

