/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import io.sentry.Breadcrumb;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ScopesAdapter;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.spring.jakarta.CachedBodyHttpServletRequest;
import io.sentry.spring.jakarta.RequestPayloadExtractor;
import io.sentry.spring.jakarta.SentryRequestHttpServletRequestProcessor;
import io.sentry.spring.jakarta.SentryRequestResolver;
import io.sentry.spring.jakarta.tracing.SpringMvcTransactionNameProvider;
import io.sentry.spring.jakarta.tracing.TransactionNameProvider;
import io.sentry.util.Objects;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;
import org.springframework.web.filter.OncePerRequestFilter;

public class SentrySpringFilter
extends OncePerRequestFilter {
    @NotNull
    private final IScopes scopesBeforeForking;
    @NotNull
    private final SentryRequestResolver requestResolver;
    @NotNull
    private final TransactionNameProvider transactionNameProvider;

    public SentrySpringFilter(@NotNull IScopes scopes, @NotNull SentryRequestResolver requestResolver, @NotNull TransactionNameProvider transactionNameProvider) {
        this.scopesBeforeForking = (IScopes)Objects.requireNonNull((Object)scopes, (String)"scopes are required");
        this.requestResolver = (SentryRequestResolver)Objects.requireNonNull((Object)requestResolver, (String)"requestResolver is required");
        this.transactionNameProvider = (TransactionNameProvider)Objects.requireNonNull((Object)transactionNameProvider, (String)"transactionNameProvider is required");
    }

    public SentrySpringFilter(@NotNull IScopes scopes) {
        this(scopes, new SentryRequestResolver(scopes), new SpringMvcTransactionNameProvider());
    }

    public SentrySpringFilter() {
        this((IScopes)ScopesAdapter.getInstance());
    }

    protected void doFilterInternal(@NotNull HttpServletRequest servletRequest, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) throws ServletException, IOException {
        if (this.scopesBeforeForking.isEnabled()) {
            HttpServletRequest request = this.resolveHttpServletRequest(this.scopesBeforeForking, servletRequest);
            @NotNull IScopes forkedScopes = this.scopesBeforeForking.forkedScopes("SentrySpringFilter");
            try (@NotNull ISentryLifecycleToken ignored = forkedScopes.makeCurrent();){
                Hint hint = new Hint();
                hint.set("springRequestFilter:request", (Object)servletRequest);
                hint.set("springRequestFilter:response", (Object)response);
                forkedScopes.addBreadcrumb(Breadcrumb.http((String)request.getRequestURI(), (String)request.getMethod()), hint);
                this.configureScope(forkedScopes, request);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)response);
        }
    }

    private void configureScope(@NotNull IScopes scopes, @NotNull HttpServletRequest request) {
        try {
            scopes.configureScope(scope -> {
                scope.setRequest(this.requestResolver.resolveSentryRequest(request));
                scope.addEventProcessor((EventProcessor)new SentryRequestHttpServletRequestProcessor(this.transactionNameProvider, request));
                if (request instanceof CachedBodyHttpServletRequest) {
                    scope.addEventProcessor((EventProcessor)new RequestBodyExtractingEventProcessor(request, scopes.getOptions()));
                }
            });
        }
        catch (Throwable e) {
            scopes.getOptions().getLogger().log(SentryLevel.ERROR, "Failed to set scope for HTTP request", e);
        }
    }

    @NotNull
    private HttpServletRequest resolveHttpServletRequest(@NotNull IScopes scopes, @NotNull HttpServletRequest request) {
        if (scopes.getOptions().isSendDefaultPii() && this.qualifiesForCaching(request, scopes.getOptions().getMaxRequestBodySize())) {
            try {
                return new CachedBodyHttpServletRequest(request);
            }
            catch (IOException e) {
                scopes.getOptions().getLogger().log(SentryLevel.WARNING, "Failed to cache HTTP request body. Request body will not be attached to Sentry events.", (Throwable)e);
                return request;
            }
        }
        return request;
    }

    private boolean qualifiesForCaching(@NotNull HttpServletRequest request, @NotNull SentryOptions.RequestSize maxRequestBodySize) {
        int contentLength = request.getContentLength();
        String contentType = request.getContentType();
        return maxRequestBodySize != SentryOptions.RequestSize.NONE && contentLength != -1 && contentType != null && SentrySpringFilter.shouldCacheMimeType(contentType) && (maxRequestBodySize == SentryOptions.RequestSize.SMALL && contentLength < 1000 || maxRequestBodySize == SentryOptions.RequestSize.MEDIUM && contentLength < 10000 || maxRequestBodySize == SentryOptions.RequestSize.ALWAYS);
    }

    private static boolean shouldCacheMimeType(String contentType) {
        return MimeType.valueOf((String)contentType).isCompatibleWith((MimeType)MediaType.APPLICATION_JSON) || MimeType.valueOf((String)contentType).isCompatibleWith((MimeType)MediaType.APPLICATION_FORM_URLENCODED);
    }

    static final class RequestBodyExtractingEventProcessor
    implements EventProcessor {
        @NotNull
        private final RequestPayloadExtractor requestPayloadExtractor = new RequestPayloadExtractor();
        @NotNull
        private final HttpServletRequest request;
        @NotNull
        private final SentryOptions options;

        public RequestBodyExtractingEventProcessor(@NotNull HttpServletRequest request, @NotNull SentryOptions options) {
            this.request = (HttpServletRequest)Objects.requireNonNull((Object)request, (String)"request is required");
            this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"options is required");
        }

        @NotNull
        public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
            if (event.getRequest() != null) {
                event.getRequest().setData((Object)this.requestPayloadExtractor.extract(this.request, this.options));
            }
            return event;
        }

        @Nullable
        public Long getOrder() {
            return 3000L;
        }
    }
}

