/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import io.sentry.IScopes;
import io.sentry.SentryLevel;
import io.sentry.protocol.Request;
import io.sentry.util.HttpUtils;
import io.sentry.util.Objects;
import io.sentry.util.UrlUtils;
import jakarta.servlet.ServletContext;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryRequestResolver {
    @NotNull
    private final IScopes scopes;
    @Nullable
    private volatile List<String> extraSecurityCookies;

    public SentryRequestResolver(@NotNull IScopes scopes) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"options is required");
    }

    @NotNull
    public Request resolveSentryRequest(@NotNull HttpServletRequest httpRequest) {
        Request sentryRequest = new Request();
        sentryRequest.setMethod(httpRequest.getMethod());
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)httpRequest.getRequestURL().toString());
        urlDetails.applyToRequest(sentryRequest);
        sentryRequest.setQueryString(httpRequest.getQueryString());
        @NotNull List<String> additionalSecurityCookieNames = this.extractSecurityCookieNamesOrUseCached(httpRequest);
        sentryRequest.setHeaders(this.resolveHeadersMap(httpRequest, additionalSecurityCookieNames));
        if (this.scopes.getOptions().isSendDefaultPii()) {
            String cookieName = "Cookie";
            @Nullable List filteredHeaders = HttpUtils.filterOutSecurityCookiesFromHeader((Enumeration)httpRequest.getHeaders(cookieName), (String)cookieName, additionalSecurityCookieNames);
            sentryRequest.setCookies(SentryRequestResolver.toString(filteredHeaders));
        }
        return sentryRequest;
    }

    @NotNull
    Map<String, String> resolveHeadersMap(@NotNull HttpServletRequest request, @NotNull List<String> additionalSecurityCookieNames) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            if (!this.scopes.getOptions().isSendDefaultPii() && HttpUtils.containsSensitiveHeader((String)headerName)) continue;
            @Nullable List filteredHeaders = HttpUtils.filterOutSecurityCookiesFromHeader((Enumeration)request.getHeaders(headerName), (String)headerName, additionalSecurityCookieNames);
            headersMap.put(headerName, SentryRequestResolver.toString(filteredHeaders));
        }
        return headersMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> extractSecurityCookieNamesOrUseCached(@NotNull HttpServletRequest httpRequest) {
        if (this.extraSecurityCookies != null) return this.extraSecurityCookies;
        Class<SentryRequestResolver> clazz = SentryRequestResolver.class;
        synchronized (SentryRequestResolver.class) {
            if (this.extraSecurityCookies != null) return this.extraSecurityCookies;
            this.extraSecurityCookies = this.extractSecurityCookieNames(httpRequest);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.extraSecurityCookies;
        }
    }

    private List<String> extractSecurityCookieNames(@NotNull HttpServletRequest httpRequest) {
        try {
            String cookieName;
            SessionCookieConfig sessionCookieConfig;
            @Nullable ServletContext servletContext = httpRequest.getServletContext();
            if (servletContext != null && (sessionCookieConfig = servletContext.getSessionCookieConfig()) != null && (cookieName = sessionCookieConfig.getName()) != null) {
                return Arrays.asList(cookieName);
            }
        }
        catch (Throwable t) {
            this.scopes.getOptions().getLogger().log(SentryLevel.WARNING, "Failed to extract session cookie name from request.", t);
        }
        return Collections.emptyList();
    }

    @Nullable
    private static String toString(@Nullable List<String> list) {
        return list != null ? String.join((CharSequence)",", list) : null;
    }
}

