/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CachedBodyServletInputStream
extends ServletInputStream {
    @NotNull
    private final InputStream cachedBodyInputStream;

    public CachedBodyServletInputStream(@NotNull byte[] cachedBody) {
        this.cachedBodyInputStream = new ByteArrayInputStream(cachedBody);
    }

    public boolean isFinished() {
        try {
            return this.cachedBodyInputStream.available() == 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(@Nullable ReadListener readListener) {
        throw new UnsupportedOperationException();
    }

    public int read() throws IOException {
        return this.cachedBodyInputStream.read();
    }

    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        return this.cachedBodyInputStream.read(b, off, len);
    }
}

