/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.webflux;

import io.sentry.IHub;
import io.sentry.protocol.Request;
import io.sentry.util.HttpUtils;
import io.sentry.util.Objects;
import io.sentry.util.UrlUtils;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;

@ApiStatus.Experimental
public class SentryRequestResolver {
    @NotNull
    private final IHub hub;

    public SentryRequestResolver(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"options is required");
    }

    @NotNull
    public Request resolveSentryRequest(@NotNull ServerHttpRequest httpRequest) {
        Request sentryRequest = new Request();
        String methodName = httpRequest.getMethod() != null ? httpRequest.getMethod().name() : "unknown";
        sentryRequest.setMethod(methodName);
        @NotNull URI uri = httpRequest.getURI();
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)uri.toString());
        urlDetails.applyToRequest(sentryRequest);
        sentryRequest.setHeaders(this.resolveHeadersMap(httpRequest.getHeaders()));
        if (this.hub.getOptions().isSendDefaultPii()) {
            String headerName = "Cookie";
            sentryRequest.setCookies(SentryRequestResolver.toString(HttpUtils.filterOutSecurityCookiesFromHeader((List)httpRequest.getHeaders().get((Object)headerName), (String)headerName, Collections.emptyList())));
        }
        return sentryRequest;
    }

    @NotNull
    Map<String, String> resolveHeadersMap(HttpHeaders request) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (Map.Entry entry : request.entrySet()) {
            String headerName = (String)entry.getKey();
            if (!this.hub.getOptions().isSendDefaultPii() && HttpUtils.containsSensitiveHeader((String)headerName)) continue;
            headersMap.put(headerName, SentryRequestResolver.toString(HttpUtils.filterOutSecurityCookiesFromHeader((List)((List)entry.getValue()), (String)headerName, Collections.emptyList())));
        }
        return headersMap;
    }

    @Nullable
    private static String toString(@Nullable List<String> enumeration) {
        return enumeration != null ? String.join((CharSequence)",", enumeration) : null;
    }
}

