/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.spring.jakarta.tracing.TransactionNameProvider;
import io.sentry.util.Objects;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class SentryExceptionResolver
implements HandlerExceptionResolver,
Ordered {
    public static final String MECHANISM_TYPE = "HandlerExceptionResolver";
    @NotNull
    private final IHub hub;
    @NotNull
    private final TransactionNameProvider transactionNameProvider;
    private final int order;

    public SentryExceptionResolver(@NotNull IHub hub, @NotNull TransactionNameProvider transactionNameProvider, int order) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.transactionNameProvider = (TransactionNameProvider)Objects.requireNonNull((Object)transactionNameProvider, (String)"transactionNameProvider is required");
        this.order = order;
    }

    @Nullable
    public ModelAndView resolveException(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @Nullable Object handler, @NotNull Exception ex) {
        Mechanism mechanism = new Mechanism();
        mechanism.setHandled(Boolean.valueOf(false));
        mechanism.setType(MECHANISM_TYPE);
        ExceptionMechanismException throwable = new ExceptionMechanismException(mechanism, (Throwable)ex, Thread.currentThread());
        SentryEvent event = new SentryEvent((Throwable)throwable);
        event.setLevel(SentryLevel.FATAL);
        event.setTransaction(this.transactionNameProvider.provideTransactionName(request));
        Hint hint = new Hint();
        hint.set("springResolver:request", (Object)request);
        hint.set("springResolver:response", (Object)response);
        this.hub.captureEvent(event, hint);
        return null;
    }

    public int getOrder() {
        return this.order;
    }
}

