/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.graphql;

import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import io.sentry.IHub;
import io.sentry.graphql.ExceptionReporter;
import io.sentry.graphql.SentrySubscriptionHandler;
import org.jetbrains.annotations.NotNull;
import org.springframework.graphql.execution.SubscriptionPublisherException;
import reactor.core.publisher.Flux;

public final class SentrySpringSubscriptionHandler
implements SentrySubscriptionHandler {
    @NotNull
    public Object onSubscriptionResult(@NotNull Object result, @NotNull IHub hub, @NotNull ExceptionReporter exceptionReporter, @NotNull InstrumentationFieldFetchParameters parameters) {
        if (result instanceof Flux) {
            @NotNull Flux flux = (Flux)result;
            return flux.doOnError(throwable -> {
                // Could not load outer class - annotation placement on inner may be incorrect
                @NotNull ExceptionReporter.ExceptionDetails exceptionDetails = new ExceptionReporter.ExceptionDetails(hub, parameters.getEnvironment(), true);
                if (throwable instanceof SubscriptionPublisherException && throwable.getCause() != null) {
                    exceptionReporter.captureThrowable(throwable.getCause(), exceptionDetails, null);
                } else {
                    exceptionReporter.captureThrowable(throwable, exceptionDetails, null);
                }
            });
        }
        return result;
    }
}

