/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.webflux;

import io.sentry.IHub;
import io.sentry.Sentry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@ApiStatus.Experimental
public final class ReactorUtils {
    @ApiStatus.Experimental
    public static <T> Mono<T> withSentry(@NotNull Mono<T> mono) {
        @NotNull IHub oldHub = Sentry.getCurrentHub();
        @NotNull IHub clonedHub = oldHub.clone();
        return ReactorUtils.withSentryHub(mono, clonedHub);
    }

    @ApiStatus.Experimental
    public static <T> Mono<T> withSentryNewMainHubClone(@NotNull Mono<T> mono) {
        @NotNull IHub hub = Sentry.cloneMainHub();
        return ReactorUtils.withSentryHub(mono, hub);
    }

    @ApiStatus.Experimental
    public static <T> Mono<T> withSentryHub(@NotNull Mono<T> mono, @NotNull IHub hub) {
        return Mono.deferContextual(ctx -> mono).contextWrite((ContextView)Context.of((Object)"sentry-hub", (Object)hub));
    }

    @ApiStatus.Experimental
    public static <T> Flux<T> withSentry(@NotNull Flux<T> flux) {
        @NotNull IHub oldHub = Sentry.getCurrentHub();
        @NotNull IHub clonedHub = oldHub.clone();
        return ReactorUtils.withSentryHub(flux, clonedHub);
    }

    @ApiStatus.Experimental
    public static <T> Flux<T> withSentryNewMainHubClone(@NotNull Flux<T> flux) {
        @NotNull IHub hub = Sentry.cloneMainHub();
        return ReactorUtils.withSentryHub(flux, hub);
    }

    @ApiStatus.Experimental
    public static <T> Flux<T> withSentryHub(@NotNull Flux<T> flux, @NotNull IHub hub) {
        return Flux.deferContextual(ctx -> flux).contextWrite((ContextView)Context.of((Object)"sentry-hub", (Object)hub));
    }
}

